/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import java.io.IOException;

class VersionControlHandler
extends BaseDavHandler {
    public VersionControlHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        VersionableItem versionableItem;
        super.processRequest(request, response, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(item)) {
            return;
        }
        VersionableItem versionableItem2 = versionableItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (versionableItem == null) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        if (versionableItem.getVersionHistory() == null) {
            versionableItem.putUnderVersionControl(true);
        }
        this.setStatus(WebDavStatus.OK);
    }
}

