/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class FilteredDavInputStream
extends InputStream {
    private InputStream stream;
    private ByteArrayOutputStream memoryStream;

    FilteredDavInputStream(InputStream stream, boolean logInput) {
        this.stream = stream;
        if (logInput) {
            this.memoryStream = new ByteArrayOutputStream();
        }
    }

    @Override
    public int read() throws IOException {
        int k = this.stream.read();
        if (this.memoryStream != null) {
            this.memoryStream.write(k);
        }
        return k;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int k = this.stream.read(bytes);
        if (this.memoryStream != null) {
            this.memoryStream.write(bytes, 0, k);
        }
        return k;
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        int k = this.stream.read(bytes, i, i1);
        if (this.memoryStream != null && k > 0) {
            this.memoryStream.write(bytes, i, k);
        }
        return k;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.stream.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public synchronized void mark(int i) {
        this.stream.mark(i);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public String toString() {
        return this.memoryStream != null ? this.memoryStream.toString() : "";
    }
}

