/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FilteredDavOutputStream
extends OutputStream {
    private final OutputStream originalStream;
    private final boolean logOutput;
    private boolean calcContentLength = true;
    private long outputContentLength = 0L;
    private ByteArrayOutputStream memoryStream;

    FilteredDavOutputStream(OutputStream originalStream, boolean logOutput, boolean calcContentLength) {
        this.originalStream = originalStream;
        this.calcContentLength = calcContentLength;
        this.logOutput = logOutput;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int i, int i1) throws IOException {
        if (!this.calcContentLength && !this.logOutput) {
            this.originalStream.write(bytes, i, i1);
        } else {
            if (this.memoryStream == null) {
                this.memoryStream = new ByteArrayOutputStream();
                this.outputContentLength = 0L;
            }
            this.outputContentLength += (long)i1;
            this.memoryStream.write(bytes, i, i1);
        }
    }

    @Override
    public void write(int i) throws IOException {
        if (!this.calcContentLength && !this.logOutput) {
            this.originalStream.write(i);
        } else {
            if (this.memoryStream == null) {
                this.memoryStream = new ByteArrayOutputStream();
                this.outputContentLength = 0L;
            }
            ++this.outputContentLength;
            this.memoryStream.write(i);
        }
    }

    public long getContentLength() {
        return this.outputContentLength;
    }

    public String toString() {
        return this.memoryStream != null ? this.memoryStream.toString() : "";
    }

    void finishWriting() throws IOException {
        if (this.memoryStream != null) {
            this.memoryStream.writeTo(this.originalStream);
            this.outputContentLength = 0L;
        }
    }
}

