/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.http;

import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.FilteredDavInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class FilteredDavRequest
extends DavRequest {
    private DavRequest request;
    private FilteredDavInputStream inputStream;
    private boolean logInput;

    public FilteredDavRequest(DavRequest request, boolean logInput) {
        this.request = request;
        this.logInput = logInput;
    }

    @Override
    public String getHeader(String s) {
        return this.request.getHeader(s);
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    @Override
    public String getServerPath() {
        return this.request.getServerPath();
    }

    @Override
    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    public long getContentLength() {
        return this.request.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    private FilteredDavInputStream getFilteredDavInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new FilteredDavInputStream(this.request.getInputStream(), this.logInput);
        }
        return this.inputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getFilteredDavInputStream();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%1s] %2s  HTTP/1.1\n", this.getMethod(), this.getRequestURI()));
        Enumeration en = this.getHeaderNames();
        while (en != null && en.hasMoreElements()) {
            String name = (String)en.nextElement();
            sb.append(String.format("%1s : %1s\n", name, this.getHeader(name)));
        }
        sb.append("\n");
        if (this.inputStream != null) {
            sb.append(this.inputStream.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }
}

