/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.http;

import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.http.FilteredDavOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;

public class FilteredDavResponse
extends DavResponse {
    private DavResponse response;
    private FilteredDavOutputStream outputStream;
    private boolean calcContentLength;
    private boolean logOutput;
    private Hashtable<String, String> headers = new Hashtable();
    private String statusDescription = "OK";
    private int statusCode = 200;

    public FilteredDavResponse(DavResponse response, boolean calcContentLength, boolean logOutput) {
        this.response = response;
        this.calcContentLength = calcContentLength;
        this.logOutput = logOutput;
    }

    public boolean isCalcContentLength() {
        return this.calcContentLength;
    }

    public FilteredDavOutputStream geFilteredDavOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new FilteredDavOutputStream(this.response.getOutputStream(), this.logOutput, this.calcContentLength);
        }
        return this.outputStream;
    }

    @Override
    public void setHeader(String s, String s1) {
        this.headers.put(s, s1);
        this.response.setHeader(s, s1);
    }

    @Override
    public Object getOriginalResponse() {
        return this.response;
    }

    @Override
    public void addHeader(String key, String value) {
        this.headers.put(key, value);
        this.response.addHeader(key, value);
    }

    public void setCalcContentLength(boolean calcContentLength) {
        this.calcContentLength = calcContentLength;
    }

    @Override
    public void setStatus(int code, String description) {
        this.statusCode = code;
        this.statusDescription = description;
        this.response.setStatus(code, description);
    }

    @Override
    public void setContentLength(long length) {
        this.setHeader("Content-Length", Long.toString(length));
        this.response.setContentLength(length);
    }

    public void finish() throws IOException {
        if (this.calcContentLength) {
            this.setContentLength(this.geFilteredDavOutputStream().getContentLength());
            this.outputStream.finishWriting();
        }
    }

    @Override
    public void setContentType(String s) {
        this.headers.put("Content-Type", s);
        this.response.setContentType(s);
    }

    @Override
    public void setCharacterEncoding(String s) {
        this.response.setCharacterEncoding(s);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.geFilteredDavOutputStream();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("HTTP/1.1 %1s %2s\n", this.statusCode, this.statusDescription));
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            sb.append(String.format("%1s : %1s\n", entry.getKey(), entry.getValue()));
        }
        sb.append("\n");
        if (this.outputStream != null) {
            sb.append(this.outputStream.toString());
        }
        return sb.toString();
    }
}

