/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.license;

import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LicenseValidator {
    private static final String PRODUCT_NAME = "IT Hit WebDAV Server Java";
    private static Calendar lastCheckTime = Calendar.getInstance();
    private static String lic = null;
    private static boolean isValid = false;
    private static boolean trialIsValid = false;
    private static boolean isExpired = true;
    private static boolean isLibExpired = true;
    private static Calendar issuedBefore;
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm";
    private static String[] months;

    private static Signature getProvider() throws ServerException {
        try {
            String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBw1E0HBIvOkQlLqRdRsTSequs5AhDbqwCBZ/e\n/zwRCBctMdjsHJvZaZXnVUutNNE55gShJtM59oWKRPN/onb56qk+sjVnCRtLLPlpGE3B4aAauaxH\nTFdcWVUmsEifSHZ/dc2sqBkJgbczuFhTfM9JR8hkqY1PcVQ4kxNNxL5lEQIDAQAB";
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(LicenseValidator.decodeUsingReflection(publicKey));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pk = keyFactory.generatePublic(keySpec);
            Signature SHA_RSA = Signature.getInstance("SHA1withRSA");
            SHA_RSA.initVerify(pk);
            return SHA_RSA;
        }
        catch (Exception ex) {
            throw new ServerException(ex);
        }
    }

    private static long parseDate(String date) throws NumberFormatException {
        String[] parts = date.split(",? ");
        int month = 1;
        for (int i = 0; i < months.length; ++i) {
            String monthName = parts[1].toLowerCase();
            if (!StringUtil.stringEquals(months[i], monthName)) continue;
            month = i;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(parts[3]), month, Integer.parseInt(parts[2]));
        return calendar.getTime().getTime();
    }

    private static Date getClassBuildTime() throws ServerException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT);
        try {
            return sdf.parse("2020-03-04 20:52");
        }
        catch (ParseException e) {
            throw new ServerException("Wrong compilation time set to LicenseUtils: 2020-03-04 20:52");
        }
    }

    private static boolean checkValid(Document xmlDocLicense, String text) throws ServerException {
        boolean valid;
        String product;
        String signature;
        String licenseData;
        try {
            licenseData = text.substring(text.indexOf("<Data>"), text.indexOf("</Data>") + "</Data>".length());
            signature = LicenseValidator.selectNode(xmlDocLicense, "//Signature").getTextContent();
            product = LicenseValidator.selectNode(xmlDocLicense, "//Product").getTextContent().trim();
        }
        catch (Exception ex) {
            throw new ServerException("Failed to read license xml.");
        }
        if (!product.equals(PRODUCT_NAME)) {
            throw new ServerException("Incorrect product license.");
        }
        Signature provider = LicenseValidator.getProvider();
        try {
            byte[] bytes = licenseData.getBytes("UTF-16LE");
            provider.update(bytes);
            valid = provider.verify(LicenseValidator.decodeUsingReflection(signature));
        }
        catch (Exception ex) {
            valid = false;
        }
        return valid;
    }

    private static boolean checkLibExpired(Document xmlDocLicense) throws ServerException {
        String issueStr;
        Node issueNode;
        String supExpStr;
        String type;
        Node subscription = LicenseValidator.selectNode(xmlDocLicense, "//Subscription");
        if (subscription != null && Boolean.parseBoolean(subscription.getTextContent().trim())) {
            return false;
        }
        try {
            type = LicenseValidator.selectNode(xmlDocLicense, "//Type").getTextContent();
        }
        catch (Exception ex) {
            throw new ServerException("Failed to read license xml.");
        }
        Node supExpNode = LicenseValidator.selectNode(xmlDocLicense, "//SupportExpirationDate");
        if (supExpNode != null && !StringUtil.isNullOrEmpty(supExpStr = supExpNode.getTextContent().trim())) {
            try {
                long suppExpirationDate = LicenseValidator.parseDate(supExpStr);
                issuedBefore = Calendar.getInstance();
                issuedBefore.setTimeInMillis(suppExpirationDate);
                return suppExpirationDate < LicenseValidator.getClassBuildTime().getTime();
            }
            catch (NumberFormatException ex) {
                throw new ServerException("Failed to read license xml.", ex);
            }
        }
        if (!"evaluation".equalsIgnoreCase(type) && (issueNode = LicenseValidator.selectNode(xmlDocLicense, "//IssueDate")) != null && !StringUtil.isNullOrEmpty(issueStr = issueNode.getTextContent().trim())) {
            try {
                long issueDate = issueStr.equals("") ? Long.MAX_VALUE : LicenseValidator.parseDate(issueStr);
                issuedBefore = Calendar.getInstance();
                issuedBefore.setTimeInMillis(issueDate);
                issuedBefore.add(1, 1);
                issuedBefore.add(6, 1);
                return issuedBefore.getTime().getTime() < LicenseValidator.getClassBuildTime().getTime();
            }
            catch (NumberFormatException ex) {
                throw new ServerException("Failed to read license xml.", ex);
            }
        }
        return false;
    }

    private static boolean checkExpired(Document xmlDocLicense) throws ServerException {
        Node subscription = LicenseValidator.selectNode(xmlDocLicense, "//Subscription");
        if (subscription != null && Boolean.parseBoolean(subscription.getTextContent().trim())) {
            String id = LicenseValidator.selectNode(xmlDocLicense, "//Id").getTextContent().trim();
            return LicenseValidator.checkSubscription(id);
        }
        Node expDateNode = LicenseValidator.selectNode(xmlDocLicense, "//ExpirationDate");
        if (expDateNode != null) {
            long expirationDate;
            String strExpirationDate = expDateNode.getTextContent().trim();
            try {
                expirationDate = strExpirationDate.equals("") ? Long.MAX_VALUE : LicenseValidator.parseDate(strExpirationDate);
            }
            catch (NumberFormatException ex) {
                throw new ServerException("Failed to read license xml.", ex);
            }
            return expirationDate < new Date().getTime();
        }
        return false;
    }

    private static boolean checkSubscription(String id) throws ServerException {
        try {
            String response = LicenseValidator.getResponse("{\"id\":\"" + id + "\", \"productNames\": [\"" + PRODUCT_NAME + "\"]}", "https://www.webdavsystem.com/api/subscriptionlicense/check");
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
            String script = "JSON.parse('" + response + "')";
            Object o = engine.eval(script);
            Map map = (Map)o;
            if (!((Boolean)map.get("IsValid")).booleanValue() && !((Boolean)map.get("IsExpired")).booleanValue()) {
                throw new ServerException("License subscription exception: " + map.get("ErrorMessage"));
            }
        }
        catch (Exception ex) {
            throw new ServerException(ex);
        }
        return false;
    }

    public static void checkLicense(String license) throws ServerException, IOException {
        Calendar newTime = Calendar.getInstance();
        newTime.setTime(lastCheckTime.getTime());
        newTime.add(10, 1);
        if (newTime.getTime().getTime() < new Date().getTime() || !license.equals(lic)) {
            if (!StringUtil.isNullOrEmpty(license)) {
                Document doc;
                DocumentBuilderFactory objDocFactory = DocumentBuilderFactory.newInstance();
                objDocFactory.setNamespaceAware(true);
                try {
                    DocumentBuilder objDocBuilder = objDocFactory.newDocumentBuilder();
                    doc = objDocBuilder.parse(new ByteArrayInputStream(license.getBytes()));
                }
                catch (SAXException e) {
                    throw new ServerException("Failed to read license xml.", e);
                }
                catch (ParserConfigurationException e) {
                    throw new ServerException(e);
                }
                isValid = LicenseValidator.checkValid(doc, license);
                isExpired = LicenseValidator.checkExpired(doc);
                isLibExpired = LicenseValidator.checkLibExpired(doc);
            } else {
                try {
                    trialIsValid = LicenseValidator.checkTrial();
                }
                catch (Exception ex) {
                    trialIsValid = false;
                }
            }
            lic = license;
            lastCheckTime.setTime(new Date());
        }
        if (!StringUtil.isNullOrEmpty(license)) {
            if (!isValid) {
                throw new ServerException("Invalid license signature.");
            }
            if (isExpired) {
                throw new ServerException("License expired.");
            }
            if (isLibExpired) {
                throw new ServerException(String.format("The license is obsolete. Your license works with updates issued before %1$tm/%1$te/%1$tY. For more information about license upgrade please visit http://www.webdavsystem.com/pricing/upgrade", issuedBefore.getTime()));
            }
        } else if (!trialIsValid) {
            throw new ServerException("Trial period has expired. To continue evaluation download a 1-month trial license. Please follow this link: http://www.webdavsystem.com/server/download/");
        }
    }

    private static Node selectNode(Document doc, String expression) throws ServerException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            XPathExpression xPathExpr = xPath.compile(expression);
            return (Node)xPathExpr.evaluate(doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new ServerException(e);
        }
    }

    private static boolean checkTrial() throws Exception {
        String response = LicenseValidator.getResponse("{\"ProductName\":\"IT Hit WebDAV Server Java\", \"MacAddress\": \"" + LicenseValidator.getMacAddress() + "\"}", "https://www.webdavsystem.com/api/license/checktriallicense").trim();
        response = StringUtil.trimStart(StringUtil.trimEnd(response, "}"), "{").trim();
        return Boolean.parseBoolean(response);
    }

    private static String getResponse(String requestJson, String serverUrl) throws Exception {
        String line;
        URL url = new URL(serverUrl);
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setDoInput(true);
        httpCon.setUseCaches(false);
        httpCon.setRequestProperty("Content-Type", "application/json");
        httpCon.setRequestProperty("Accept", "application/json");
        httpCon.setRequestMethod("POST");
        httpCon.connect();
        OutputStream os = httpCon.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        osw.write(requestJson);
        osw.flush();
        osw.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(httpCon.getInputStream(), "utf-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        return sb.toString();
    }

    private static String getMacAddress() throws Exception {
        InetAddress lanIp = null;
        Enumeration<NetworkInterface> net = NetworkInterface.getNetworkInterfaces();
        while (net.hasMoreElements()) {
            NetworkInterface element = net.nextElement();
            Enumeration<InetAddress> addresses = element.getInetAddresses();
            if (element.getHardwareAddress() == null) continue;
            while (addresses.hasMoreElements() && element.getHardwareAddress().length > 0 && !LicenseValidator.isVMMac(element.getHardwareAddress())) {
                InetAddress ip = addresses.nextElement();
                if (!(ip instanceof Inet4Address) || !ip.isSiteLocalAddress()) continue;
                String ipAddress = ip.getHostAddress();
                lanIp = InetAddress.getByName(ipAddress);
            }
        }
        if (lanIp == null) {
            throw new IllegalStateException("Ip address not found");
        }
        return LicenseValidator.getMacAddress(lanIp);
    }

    private static String getMacAddress(InetAddress ip) throws SocketException {
        NetworkInterface network = NetworkInterface.getByInetAddress(ip);
        byte[] mac = network.getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    private static boolean isVMMac(byte[] mac) {
        byte[][] invalidMacs;
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}}) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    private static byte[] decodeUsingReflection(String publicKey) throws IOException {
        Class<?> decodeClass2;
        try {
            decodeClass2 = Class.forName("java.util.Base64");
            if (decodeClass2 != null) {
                String staticMethodName = "getMimeDecoder";
                Class[] formalParameters = new Class[]{String.class};
                Object[] effectiveParameters = new Object[]{publicKey};
                Method method = decodeClass2.getMethod(staticMethodName, new Class[0]);
                Object decoder = method.invoke(null, new Object[0]);
                Class<?> decoderClass = decoder.getClass();
                String instanceMethodName = "decode";
                method = decoderClass.getMethod(instanceMethodName, formalParameters);
                Object result = method.invoke(decoder, effectiveParameters);
                return (byte[])result;
            }
        }
        catch (Exception decodeClass2) {
            // empty catch block
        }
        try {
            decodeClass2 = Class.forName("sun.misc.BASE64Decoder");
            if (decodeClass2 != null) {
                String instanceMethodName = "decodeBuffer";
                Class[] formalParameters = new Class[]{String.class};
                Object[] effectiveParameters = new Object[]{publicKey};
                Method method = decodeClass2.getMethod(instanceMethodName, formalParameters);
                Object newInstance = decodeClass2.newInstance();
                Object result = method.invoke(newInstance, effectiveParameters);
                return (byte[])result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IOException("Both java.util.Base64 and sun.misc.BASE64Decoder cannot decode license");
    }

    static {
        months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    }
}

