/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.resumableupload;

import com.ithit.webdav.server.resumableupload.ContentStream;
import com.ithit.webdav.server.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class PostReader {
    private final int CHUNK_SIZE = 8096;
    private final byte[] boundaryBytes;
    private final String encoding;
    private InputStream inputStream;
    private final byte[] lineFeed;
    private ContentStream contentStream;
    private final String boundary;
    private String fileName;
    private String contentType;
    private final byte[] readCachedData;
    private int readCachedDataLength;
    private boolean inputStreamEnded = false;
    private String name;
    private final long length;
    private long bytesRead = 0L;

    public PostReader(InputStream inputStream, String boundary, String encoding, long length) throws UnsupportedEncodingException {
        this.encoding = encoding;
        this.inputStream = inputStream;
        this.boundary = boundary;
        this.boundaryBytes = ("\r\n--" + boundary).getBytes(encoding);
        this.lineFeed = "\r\n".getBytes(encoding);
        this.readCachedData = new byte[8096 + this.boundaryBytes.length];
        this.length = length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFile() {
        return this.fileName != null;
    }

    public ContentStream getContentStream() {
        return this.contentStream;
    }

    public String getName() {
        return this.name;
    }

    public long getContentLength() {
        return this.length;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public boolean moveNext() throws IOException {
        long contentLength;
        this.fileName = null;
        byte[] localBuffer = new byte[20000];
        if (this.getContentStream() != null) {
            while (this.getContentStream().read(localBuffer, 0, localBuffer.length) > 0) {
            }
            this.readTillSeparator(localBuffer, 0, localBuffer.length, this.boundaryBytes, true);
        } else {
            this.readTillSeparator(localBuffer, 0, localBuffer.length, this.boundary.getBytes(this.encoding), true);
        }
        String suffix = this.readLine(localBuffer, true);
        if (StringUtil.stringEquals(suffix, "--")) {
            return false;
        }
        boolean found = false;
        String header = this.readLine(localBuffer, false);
        while (!StringUtil.isNullOrEmpty(header)) {
            if (header.toLowerCase().startsWith("content-disposition:")) {
                String[] attributes;
                found = true;
                for (String att : attributes = header.split(";")) {
                    String attTrim = att.trim();
                    if (attTrim.toLowerCase().startsWith("filename=")) {
                        this.fileName = attTrim.substring(9).trim().replace("\"", "");
                    }
                    if (!attTrim.toLowerCase().startsWith("name=")) continue;
                    this.name = attTrim.substring(5).trim().replace("\"", "");
                }
            }
            if (header.toLowerCase().startsWith("content-type:")) {
                this.contentType = header.substring(13).trim();
            }
            this.readLine(localBuffer, true);
            header = this.readLine(localBuffer, false);
        }
        if (this.indexOf(this.readCachedData, this.boundaryBytes, 0, this.boundaryBytes.length) != 0) {
            this.readLine(localBuffer, true);
        }
        this.contentStream = new ContentStream(this, (contentLength = (long)((int)(this.getContentLength() - this.getBytesRead() - (long)(this.boundaryBytes.length + "--".length()) - (long)this.lineFeed.length))) < 0L ? -1L : contentLength);
        return found;
    }

    private int readTillSeparator(byte[] buffer, int start, int count, byte[] separator, boolean including) throws IOException {
        int totalRead = 0;
        for (int i = 0; i < count; i += 8096) {
            int toRead = Math.min(8096, count - i);
            int read = this.readTillSeparatorInChunks(buffer, start + i, toRead, separator, including);
            totalRead += read;
            if (read < toRead) break;
        }
        return totalRead;
    }

    private int readTillSeparatorInChunks(byte[] buffer, int start, int count, byte[] separator, boolean including) throws IOException {
        assert (count + separator.length <= this.readCachedData.length);
        int toRead = Math.max(0, count + separator.length - this.readCachedDataLength);
        int read = this.inputStream.read(this.readCachedData, this.readCachedDataLength, toRead);
        if (read <= 0) {
            this.inputStreamEnded = true;
        }
        this.readCachedDataLength += read >= 0 ? read : 0;
        int index = this.indexOf(this.readCachedData, separator, 0, this.readCachedDataLength);
        int toReturn = index >= 0 ? Math.min(count, index) : Math.min(count, this.readCachedDataLength);
        System.arraycopy(this.readCachedData, 0, buffer, start, toReturn);
        int add = including && index >= 0 ? separator.length : 0;
        System.arraycopy(this.readCachedData, toReturn + add, this.readCachedData, 0, this.readCachedDataLength - toReturn - add);
        this.readCachedDataLength -= toReturn + add;
        this.bytesRead += (long)(toReturn + add);
        return toReturn;
    }

    int readTillBoundary(byte[] buffer, int offset, int count) throws IOException {
        return this.readTillSeparator(buffer, offset, count, this.boundaryBytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(byte[] buffer, boolean including) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            int read;
            while ((read = this.readTillSeparator(buffer, 0, buffer.length, this.lineFeed, including)) == buffer.length) {
                stream.write(buffer, 0, read);
            }
            if (this.inputStreamEnded && this.readCachedDataLength == 0) {
                String string = null;
                return string;
            }
            stream.write(buffer, 0, read);
            String string = new String(stream.toByteArray(), 0, stream.size(), this.encoding);
            return string;
        }
        finally {
            stream.close();
        }
    }

    private int indexOf(byte[] buffer, byte[] checkFor, int start, int count) {
        int startPos = this.indexOf(buffer, checkFor[0], start, count);
        while (startPos >= 0 && startPos + checkFor.length <= start + count) {
            int i;
            for (i = 0; i < checkFor.length && buffer[startPos + i] == checkFor[i]; ++i) {
            }
            if (i == checkFor.length) {
                return startPos;
            }
            startPos = this.indexOf(buffer, checkFor[0], startPos + 1, count - startPos - 1);
        }
        return -1;
    }

    private int indexOf(byte[] buffer, byte b, int start, int count) {
        for (int i = start; i < start + count; ++i) {
            if (buffer[i] != b) continue;
            return i;
        }
        return -1;
    }
}

