/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.util;

import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ChildIterable
implements Iterable<Node> {
    private final NodeList nodeList;

    public ChildIterable(Node node) {
        this.nodeList = node.getChildNodes();
    }

    public ChildIterable(NodeList nodeList) {
        this.nodeList = nodeList;
    }

    @Override
    public Iterator<Node> iterator() {
        return new ChildIterator(this.nodeList);
    }

    private class ChildIterator
    implements Iterator<Node> {
        private final NodeList list;
        private Node next;
        private int current = -1;

        ChildIterator(NodeList list) {
            this.list = list;
            this.setNext();
        }

        private void setNext() {
            this.next = null;
            ++this.current;
            while (this.current < this.list.getLength()) {
                if (this.list.item(this.current).getNodeType() == 1 || this.list.item(this.current).getNodeType() == 3 && this.list.item(this.current).getNodeValue() != null && this.list.item(this.current).getNodeValue().trim().length() > 0) {
                    this.next = this.list.item(this.current);
                    break;
                }
                ++this.current;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node next() {
            Node n = this.next;
            this.setNext();
            return n;
        }

        @Override
        public void remove() {
        }
    }
}

