/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.util;

import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.util.ArgumentUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;

public class RequestUtil {
    public static String getRequestPathAndQueryString(DavRequest request) {
        String path = request.getRequestURI();
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "/");
        }
        if (request.getQueryString() != null && request.getQueryString().length() > 0) {
            path = path + "?" + request.getQueryString();
        }
        return RequestUtil.stripContextPath(path, request);
    }

    public static String getPathAndQueryString(String href, DavRequest request) throws ServerException {
        URI uri;
        try {
            uri = new URI(href);
        }
        catch (URISyntaxException e) {
            throw new ServerException((Throwable)e, WebDavStatus.BAD_REQUEST);
        }
        String path = uri.getRawPath();
        if (uri.getRawQuery() != null && uri.getRawQuery().length() > 0) {
            path = path + "?" + uri.getRawQuery();
        }
        return RequestUtil.stripContextPath(path, request);
    }

    public static String getRequestPath(DavRequest request) {
        return RequestUtil.stripContextPath(request.getRequestURI(), request);
    }

    public static String createUrl(String href, DavRequest request) {
        String appPath = StringUtil.trimEnd(request.getContextPath() + request.getServerPath(), "/");
        return RequestUtil.getRequestHost(request) + appPath + "/" + StringUtil.trimStart(href, "/");
    }

    private static String getRequestHost(DavRequest request) {
        String port = ":" + request.getServerPort();
        if ("http".equals(request.getScheme()) && request.getServerPort() == 80 || "https".equals(request.getScheme()) && request.getServerPort() == 443) {
            port = "";
        }
        return request.getScheme() + "://" + request.getServerName() + port;
    }

    public static String getGuidFromToken(String token) {
        ArgumentUtil.checkArgumentNotNull(token, "token");
        int i = token.indexOf(58);
        int j = token.indexOf(62);
        if (j < 0) {
            j = token.length();
        }
        return token.substring(i + 1, j);
    }

    public static String stripContextPath(String path, DavRequest request) {
        String appPath = StringUtil.trimEnd(request.getContextPath() + request.getServerPath(), "/");
        if (appPath.length() == 0) {
            return path;
        }
        if (path.length() > appPath.length()) {
            return path.substring(appPath.length());
        }
        return "/";
    }
}

