/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.exceptions.ItemResponse;
import com.ithit.webdav.server.exceptions.MultistatusResponse;
import com.ithit.webdav.server.exceptions.PropStat;
import com.ithit.webdav.server.exceptions.PropStatResponse;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.http.FilteredDavResponse;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.ResponseUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MultistatusResponseWriter {
    private DavResponse a;
    private DavRequest b;
    private XMLStreamWriter c;
    private String d;

    public MultistatusResponseWriter(DavRequest davRequest, DavResponse davResponse, String string) {
        this.a = davResponse;
        this.b = davRequest;
        this.d = string;
    }

    public void startMultiStatusResponse() throws XMLStreamException, IOException {
        this.startMultiStatusResponse(false);
    }

    public void startMultiStatusResponse(boolean bl) throws XMLStreamException, IOException {
        this.a.setStatus(207, "Multi-Status");
        this.c = ResponseUtil.createXmlResponse(this.a, this.d);
        this.c.writeStartDocument();
        this.c.setPrefix("d", "DAV:");
        this.c.writeStartElement("DAV:", "multistatus");
        this.c.writeNamespace("d", "DAV:");
        if (bl) {
            this.c.writeAttribute("xmlns", "", "ithitp", "https://www.ithit.com/pagingschema/");
        }
    }

    public void endMultiStatusResponse() throws XMLStreamException, IOException {
        FilteredDavResponse filteredDavResponse;
        this.c.writeEndElement();
        this.c.writeEndDocument();
        if (this.a instanceof FilteredDavResponse && (filteredDavResponse = (FilteredDavResponse)this.a).isCalcContentLength()) {
            int n2 = (int)filteredDavResponse.geFilteredDavOutputStream().getContentLength();
            filteredDavResponse.setContentLength(n2);
        }
        this.c.flush();
    }

    public void startResponse(String string) throws XMLStreamException, ServerException {
        this.c.writeStartElement("DAV:", "response");
        this.writeItemHref(this.c, string);
    }

    public void endResponse() throws XMLStreamException {
        this.c.writeEndElement();
    }

    public void addStatusResponse(Response response) throws XMLStreamException, IOException, ServerException {
        this.startResponse(response.getItemPath());
        if (response instanceof PropStatResponse) {
            for (PropStat propStat : ((PropStatResponse)response).getPropStats()) {
                this.c.writeStartElement("DAV:", "propstat");
                this.c.writeStartElement("DAV:", "prop");
                for (Property property : propStat.getProperties()) {
                    MultistatusResponse.writeElementString(this.c, property.getName(), property.getNamespace(), "");
                }
                this.c.writeEndElement();
                MultistatusResponse.writeElementString(this.c, "status", "DAV:", propStat.getStatus().getHttpString());
                this.c.writeEndElement();
            }
        } else {
            WebDavStatus webDavStatus = ((ItemResponse)response).getStatus();
            MultistatusResponse.writeElementString(this.c, "status", "DAV:", webDavStatus.getHttpString());
        }
        if (response.getResponseDescription() != null && response.getResponseDescription().length() > 0) {
            MultistatusResponse.writeElementString(this.c, "responsedescription", "DAV:", response.getResponseDescription());
        }
        this.endResponse();
    }

    public void writeItemHref(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException, ServerException {
        string = RequestUtil.createUrl(string, this.b);
        xMLStreamWriter.writeStartElement("d", "href", "DAV:");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
    }

    public void startPropStat() throws XMLStreamException {
        this.c.writeStartElement("DAV:", "propstat");
    }

    public void writeItemStatus(WebDavStatus webDavStatus) throws XMLStreamException {
        MultistatusResponse.writeElementString(this.c, "status", "DAV:", webDavStatus.getHttpString());
    }

    public void endPropStat() throws XMLStreamException {
        this.c.writeEndElement();
    }

    public void startProp() throws XMLStreamException {
        this.c.writeStartElement("DAV:", "prop");
    }

    public void endProp() throws XMLStreamException {
        this.c.writeEndElement();
    }

    public void writeProperty(String string, String string2, String string3) throws XMLStreamException {
        MultistatusResponse.writeElementString(this.c, string, string2, string3);
    }

    public void writePropertyWithPrefix(String object, String string, String string2, String string3) throws XMLStreamException {
        String string4 = string3;
        string3 = string2;
        string2 = string;
        string = object;
        object = this.c;
        if (string3 != null && string3.equals("DAV:")) {
            object.writeStartElement(string3, string2);
            object.writeCharacters(string4);
            object.writeEndElement();
            return;
        }
        object.writeStartElement(string, string2, string3);
        object.writeCharacters(string4);
        object.writeEndElement();
    }

    public void writeEmptyProperty(String string, String string2) throws XMLStreamException {
        this.c.writeEmptyElement(string2, string);
    }

    public void writeEmptyProperty(String string, String string2, String string3) throws XMLStreamException {
        this.c.writeEmptyElement(string3, string, string2);
    }

    public XMLStreamWriter startProperty(String string, String string2) throws XMLStreamException {
        this.c.writeStartElement(string, string2);
        return this.c;
    }

    public void endProperty() throws XMLStreamException {
        this.c.writeEndElement();
    }

    public void writeXmlRawProperty(String object, String string, String string2) throws XMLStreamException {
        String string3 = string;
        string = object;
        object = this.c;
        if (string3 != null && string3.equals("DAV:")) {
            object.writeStartElement(string3, string);
        } else {
            object.writeStartElement(string);
            object.writeDefaultNamespace(string3);
        }
        this.c.writeCharacters("");
        this.c.flush();
        try {
            object = new OutputStreamWriter(this.a.getOutputStream());
            ((Writer)object).write(string2);
            ((OutputStreamWriter)object).flush();
            object = this.c;
            object.writeEndElement();
            return;
        }
        catch (Exception exception) {
            throw new XMLStreamException(exception);
        }
    }
}

