/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.util;

import com.ithit.webdav.server.DavRequest;
import com.ithit.webdav.server.DavResponse;

public class DavContext {
    private static final ThreadLocal<DavRequest> a = new ThreadLocal();
    private static final ThreadLocal<DavResponse> b = new ThreadLocal();

    private DavContext() {
    }

    public static void setDavRequest(DavRequest davRequest) {
        if (davRequest == null) {
            a.remove();
            return;
        }
        a.set(davRequest);
    }

    public static void setDavResponse(DavResponse davResponse) {
        if (davResponse == null) {
            b.remove();
            return;
        }
        b.set(davResponse);
    }

    public static DavRequest currentRequest() throws IllegalStateException {
        DavRequest davRequest = a.get();
        if (davRequest == null) {
            throw new IllegalStateException("No thread-bound request found: Are you referring to request outside of an actual web request, or processing a request outside of the originally receiving thread?");
        }
        return davRequest;
    }

    public static DavResponse currentResponse() throws IllegalStateException {
        DavResponse davResponse = b.get();
        if (davResponse == null) {
            throw new IllegalStateException("No thread-bound response found: Are you referring to response outside of an actual web request, or processing a response outside of the originally receiving thread?");
        }
        return davResponse;
    }
}

