/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server;

import com.ithit.webdav.server.DavContext;
import com.ithit.webdav.server.DavRequest;
import com.ithit.webdav.server.DavResponse;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.MethodHandler;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.HandlerFactory;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.FilteredDavRequest;
import com.ithit.webdav.server.http.FilteredDavResponse;
import com.ithit.webdav.server.license.LicenseValidator;
import com.ithit.webdav.server.util.ArgumentUtil;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.ResponseUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public abstract class Engine {
    private final Hashtable<String, MethodHandler> a = new Hashtable();
    private static final Set<String> b = Collections.singleton("Authorization");
    private static final Set<String> c = Collections.singleton("WWW-Authenticate");
    private static String d;

    public abstract HierarchyItem getHierarchyItem(String var1) throws ServerException;

    public abstract Logger getLogger();

    public abstract String getLicense();

    public String getResponseCharacterEncoding() {
        return "UTF-8";
    }

    public MethodHandler registerMethodHandler(String string, MethodHandler methodHandler) {
        ArgumentUtil.checkArgumentNotNull(string, "method");
        ArgumentUtil.checkArgumentNotNull(methodHandler, "handler");
        ArgumentUtil.checkArgument(string.length() > 0, "method should not be empty");
        string = string.toUpperCase();
        MethodHandler methodHandler2 = this.a.get(string);
        this.a.put(string, methodHandler);
        if (methodHandler2 != null) {
            return methodHandler2;
        }
        Engine engine = this;
        return HandlerFactory.createHandler(string, engine, engine.getLogger());
    }

    public static List<String> getClientLockTokens(DavRequest davRequest) {
        return davRequest.getClientLockTokens();
    }

    public boolean getAutoPutUnderVersionControl() {
        return false;
    }

    public boolean getCalculateContentLength() {
        return true;
    }

    public Set<String> getMaskRequestHeaders() {
        return b;
    }

    public Set<String> getMaskResponseHeaders() {
        return c;
    }

    public void service(DavRequest object, DavResponse object2) throws DavException, IOException {
        ArgumentUtil.checkArgumentNotNull(object, "davRequest");
        ArgumentUtil.checkArgumentNotNull(object2, "davResponse");
        DavContext.a((DavRequest)object);
        DavContext.a((DavResponse)object2);
        try {
            Object object3;
            Object object4 = this.getLicense();
            LicenseValidator.checkLicense((String)object4);
            Object object5 = "IT Hit WebDAV Server v" + Engine.getVersion();
            if (((String)object4).contains("Evaluation")) {
                object5 = (String)object5 + " (Evaluation License)";
            }
            object4 = object2;
            object2 = object;
            object = this;
            Object object6 = object3 = ((DavRequest)object2).getMethod().toUpperCase();
            Object object7 = object;
            Object object8 = ((Engine)object7).a.get(object6);
            if (object8 == null) {
                Object object9 = object7;
                object8 = HandlerFactory.createHandler((String)object6, (Engine)object9, ((Engine)object9).getLogger());
            }
            object3 = object8;
            FilteredDavRequest filteredDavRequest = new FilteredDavRequest((DavRequest)object2, ((Engine)object).getLogger().isDebugEnabled() && object3 != null && object3.getLogInput(), ((Engine)object).getMaskRequestHeaders());
            FilteredDavResponse filteredDavResponse = new FilteredDavResponse((DavResponse)object4, ((Engine)object).getCalculateContentLength(), ((Engine)object).getLogger().isDebugEnabled() && object3 != null && object3.getLogOutput(), ((Engine)object).getMaskResponseHeaders());
            object6 = filteredDavResponse;
            object7 = object2;
            object7 = ((DavRequest)object7).getHeader("Origin");
            ((DavResponse)object6).addHeader("Access-Control-Allow-Origin", StringUtil.isNullOrEmpty((String)object7) ? "*" : StringUtil.trimEnd((String)object7, "/"));
            ((DavResponse)object6).addHeader("Access-Control-Allow-Credentials", "true");
            ((DavResponse)object6).addHeader("Access-Control-Allow-Methods", "PROPFIND, PROPPATCH, COPY, MOVE, DELETE, MKCOL, LOCK, UNLOCK, PUT, GETLIB, VERSION-CONTROL, CHECKIN, CHECKOUT, UNCHECKOUT, REPORT, UPDATE, CANCELUPLOAD, HEAD, OPTIONS, GET, POST");
            ((DavResponse)object6).addHeader("Access-Control-Allow-Headers", "Overwrite, Destination, Content-Type, Depth, User-Agent, Translate, Range, Content-Range, Timeout, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control, Location, Lock-Token, If");
            ((DavResponse)object6).addHeader("Access-Control-Expose-Headers", "DAV, content-length, Allow");
            ((DavResponse)object6).addHeader("Access-Control-Max-Age", Integer.toString(Integer.MAX_VALUE));
            object8 = filteredDavResponse;
            object6 = object5;
            object7 = object;
            if (((Engine)object7).getLogger().isDebugEnabled() || ((String)object6).contains("(Evaluation License)")) {
                ((FilteredDavResponse)object8).addHeader("X-Engine", (String)object6);
            }
            try {
                object7 = object3;
                if (object7 == null) {
                    throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
                }
                if (!object3.getCalculateContentLength()) {
                    filteredDavResponse.setCalcContentLength(false);
                }
                object5 = ((Engine)object).getHierarchyItem(RequestUtil.getRequestPathAndQueryString((DavRequest)object2));
                object3.processRequest(filteredDavRequest, filteredDavResponse, (HierarchyItem)object5);
            }
            catch (MultistatusException multistatusException) {
                filteredDavResponse.setStatus(multistatusException.getStatus().getCode(), multistatusException.getStatus().getDescription());
                super.a(filteredDavRequest, filteredDavResponse, multistatusException);
            }
            catch (DavException davException) {
                filteredDavResponse.setStatus(davException.getStatus().getCode(), davException.getStatus().getDescription());
                if (!super.a((DavResponse)object4, davException) && ((Engine)object).getCalculateContentLength()) {
                    ((DavResponse)object4).setContentLength(0L);
                }
                if (davException instanceof ServerException && davException.getCause() != null && davException.getStatus() == WebDavStatus.INTERNAL_ERROR) {
                    object7 = object2;
                    object8 = ((DavRequest)object7).getMethod();
                    if (!((String)object8).equalsIgnoreCase("HEAD") && !((String)object8).equalsIgnoreCase("OPTIONS")) {
                        object2 = davException.getMessage().getBytes(((Engine)object).getResponseCharacterEncoding());
                        filteredDavResponse.geFilteredDavOutputStream().write((byte[])object2, 0, ((Object)object2).length);
                    }
                    ((Engine)object).getLogger().logError(davException.getMessage(), davException);
                    throw davException;
                }
            }
            finally {
                filteredDavResponse.finish();
                if (((Engine)object).getLogger().isDebugEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("\n\n");
                    stringBuilder.append(filteredDavRequest);
                    stringBuilder.append("\n\n");
                    stringBuilder.append(filteredDavResponse);
                    ((Engine)object).getLogger().logDebug(stringBuilder.toString());
                }
            }
            return;
        }
        catch (IOException iOException) {
            this.getLogger().logError(iOException.getMessage(), iOException);
            throw iOException;
        }
        finally {
            DavContext.reset();
        }
    }

    public static String getVersion() {
        if (d == null || d.equals("")) {
            d = "7.3.10625";
        }
        return d;
    }

    private void a(DavRequest object, DavResponse responseArray, MultistatusException multistatusException) throws ServerException, IOException {
        object = new MultistatusResponseWriter((DavRequest)object, (DavResponse)responseArray, this.getResponseCharacterEncoding());
        try {
            ((MultistatusResponseWriter)object).startMultiStatusResponse();
            for (Response response : multistatusException.getResponses()) {
                ((MultistatusResponseWriter)object).addStatusResponse(response);
            }
            ((MultistatusResponseWriter)object).endMultiStatusResponse();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerException(xMLStreamException);
        }
    }

    private boolean a(DavResponse object, DavException davException) throws IOException {
        DavException davException2 = davException;
        DavResponse davResponse = object;
        Object object2 = this;
        try {
            davResponse.addHeader("X-MSDAVEXT_ERROR", davException2.getExtendedError() + "; " + (davException2.getMessage() == null ? "" : URLEncoder.encode(davException2.getMessage(), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ((Engine)object2).getLogger().logError("UTF-8 not found", unsupportedEncodingException);
        }
        try {
            if (!StringUtil.isNullOrEmpty(davException.getLocalName()) || !StringUtil.isNullOrEmpty(davException.getMessage())) {
                object = ResponseUtil.createXmlResponse((DavResponse)object, this.getResponseCharacterEncoding());
                object.writeStartDocument();
                object2 = "DAV:";
                object.writeStartElement("d", "error", (String)object2);
                object.writeNamespace("d", (String)object2);
                if (!StringUtil.isNullOrEmpty(davException.getLocalName())) {
                    if (((String)object2).equals(davException.getNamespace())) {
                        object.writeEmptyElement("d", davException.getLocalName(), (String)object2);
                    } else {
                        object.writeNamespace("m", davException.getNamespace());
                        object.writeEmptyElement("m", davException.getLocalName(), davException.getNamespace());
                    }
                }
                if (!StringUtil.isNullOrEmpty(davException.getMessage())) {
                    object.writeStartElement("d", "responsedescription", (String)object2);
                    object.writeCharacters(davException.getMessage());
                    object.writeEndElement();
                }
                object.writeEndElement();
                object.writeEndDocument();
                object.flush();
                return true;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            this.getLogger().logError("", xMLStreamException);
        }
        return false;
    }
}

