/*
 * Decompiled with CFR 0.152.
 */
package com.jarslab.maven.babel.plugin;

import com.jarslab.maven.babel.plugin.TargetFileWriter;
import com.jarslab.maven.babel.plugin.TranspilationInitializer;
import com.jarslab.maven.babel.plugin.transpiler.BabelTranspilerFactory;
import com.jarslab.maven.babel.plugin.transpiler.BabelTranspilerStrategy;
import com.jarslab.maven.babel.plugin.transpiler.Transpilation;
import com.jarslab.maven.babel.plugin.transpiler.TranspileStrategy;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="babel", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class BabelMojo
extends AbstractMojo {
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose = false;
    @Deprecated
    @Parameter(property="parallel", defaultValue="false")
    private boolean parallel = false;
    @Parameter(property="threads", defaultValue="1")
    private int threads = 1;
    @Parameter(property="babelSrc", required=true)
    private File babelSrc;
    @Parameter(property="sourceDir", required=true)
    private File sourceDir;
    @Parameter(property="targetDir", required=true)
    private File targetDir;
    @Parameter(property="jsSourceFiles", alias="jsFiles")
    private List<String> jsSourceFiles = new ArrayList<String>();
    @Parameter(property="jsSourceIncludes", alias="jsIncludes")
    private List<String> jsSourceIncludes = new ArrayList<String>();
    @Parameter(property="jsSourceExcludes", alias="jsExcludes")
    private List<String> jsSourceExcludes = new ArrayList<String>();
    @Parameter(property="prefix")
    private String prefix;
    @Parameter(property="presets", defaultValue="es2015")
    private String presets;
    @Parameter(property="encoding")
    private String encoding = Charset.defaultCharset().name();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Charset charset = Charset.forName(this.encoding);
        if (this.verbose) {
            this.getLog().info((CharSequence)"Run in the verbose mode.");
            this.getLog().info((CharSequence)String.format("Charset: %s.", charset));
            this.getLog().debug((CharSequence)this.toString());
        }
        if (!this.babelSrc.exists() || !this.babelSrc.canRead()) {
            this.getLog().error((CharSequence)"Given Babel file is not reachable.");
            throw new MojoFailureException("Given Babel file is not reachable.");
        }
        if (this.presets.isEmpty()) {
            throw new MojoFailureException("No Babel presets defined.");
        }
        if (this.jsSourceFiles.isEmpty() && this.jsSourceIncludes.isEmpty()) {
            this.getLog().warn((CharSequence)"No source files provided, nothing to do.");
            return;
        }
        if (this.threads == 1 && this.parallel) {
            this.threads = 2;
        }
        TranspileStrategy transpileStrategy = this.threads > 1 ? TranspileStrategy.PARALLEL : TranspileStrategy.SEQUENTIAL;
        TranspilationInitializer transpilationInitializer = new TranspilationInitializer(this);
        Set<Transpilation> transpilations = transpilationInitializer.getTranspilations();
        if (transpilations.isEmpty()) {
            this.getLog().info((CharSequence)"No files found to transpile.");
            return;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)String.format("Found %s files to transpile.", transpilations.size()));
        }
        BabelTranspilerStrategy transpiler = BabelTranspilerFactory.getTranspiler(transpileStrategy, this);
        try {
            ((Stream)transpiler.execute(transpilations).parallel()).forEach(TargetFileWriter::writeTargetFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed on Babel transpile execution.", e);
        }
        this.getLog().info((CharSequence)"Babel transpile execution successful.");
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Deprecated
    public boolean isParallel() {
        return this.parallel;
    }

    public int getThreads() {
        return this.threads;
    }

    public File getBabelSrc() {
        return this.babelSrc;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public List<String> getJsSourceFiles() {
        return this.jsSourceFiles;
    }

    public List<String> getJsSourceIncludes() {
        return this.jsSourceIncludes;
    }

    public List<String> getJsSourceExcludes() {
        return this.jsSourceExcludes;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPresets() {
        return this.presets;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Deprecated
    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setBabelSrc(File babelSrc) {
        this.babelSrc = babelSrc;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public void setJsSourceFiles(List<String> jsSourceFiles) {
        this.jsSourceFiles = jsSourceFiles;
    }

    public void setJsSourceFile(String jsSourceFile) {
        this.jsSourceFiles.add(jsSourceFile);
    }

    public void setJsSourceIncludes(List<String> jsSourceIncludes) {
        this.jsSourceIncludes = jsSourceIncludes;
    }

    public void setJsSourceInclude(String jsSourceInclude) {
        this.jsSourceIncludes.add(jsSourceInclude);
    }

    public void setJsSourceExcludes(List<String> jsSourceExcludes) {
        this.jsSourceExcludes = jsSourceExcludes;
    }

    public void setJsSourceExclude(String jsSourceExclude) {
        this.jsSourceExcludes.add(jsSourceExclude);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPresets(String presets) {
        this.presets = presets;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        return "BabelMojo{verbose=" + this.verbose + ", parallel=" + this.parallel + ", threads=" + this.threads + ", babelSrc=" + this.babelSrc + ", sourceDir=" + this.sourceDir + ", targetDir=" + this.targetDir + ", jsSourceFiles=" + this.jsSourceFiles + ", jsSourceIncludes=" + this.jsSourceIncludes + ", jsSourceExcludes=" + this.jsSourceExcludes + ", prefix='" + this.prefix + '\'' + ", presets='" + this.presets + '\'' + ", encoding='" + this.encoding + '\'' + '}';
    }
}

