/*
 * Decompiled with CFR 0.152.
 */
package com.jarslab.maven.babel.plugin;

import com.jarslab.maven.babel.plugin.BabelMojo;
import com.jarslab.maven.babel.plugin.transpiler.ImmutableTranspilation;
import com.jarslab.maven.babel.plugin.transpiler.ImmutableTranspilationContext;
import com.jarslab.maven.babel.plugin.transpiler.Transpilation;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.util.DirectoryScanner;

class TranspilationInitializer {
    private final BabelMojo babelMojo;

    TranspilationInitializer(BabelMojo babelMojo) {
        this.babelMojo = Objects.requireNonNull(babelMojo);
    }

    Set<Transpilation> getTranspilations() {
        HashSet<ImmutableTranspilation.Builder> transpilations = new HashSet<ImmutableTranspilation.Builder>();
        ImmutableTranspilationContext context = ImmutableTranspilationContext.builder().babelSource(this.babelMojo.getBabelSrc()).charset(Charset.forName(this.babelMojo.getEncoding())).log(this.babelMojo.getLog()).isVerbose(this.babelMojo.isVerbose()).presets(this.getFormattedPresets(this.babelMojo)).build();
        this.addStaticFiles(transpilations);
        this.addPatternMatchedFiles(transpilations);
        return transpilations.stream().map(transpilation -> transpilation.context(context).build()).collect(Collectors.toSet());
    }

    private void addStaticFiles(Set<ImmutableTranspilation.Builder> sourceFiles) {
        this.babelMojo.getJsSourceFiles().stream().map(this::removeLeadingSlash).map(this::resolveAgainstSourceDirectory).filter(sourcePath -> Files.exists(sourcePath, new LinkOption[0])).map(this::toTranspilationBuilder).forEach(sourceFiles::add);
    }

    private Path resolveAgainstSourceDirectory(String sourcePath) {
        return this.babelMojo.getSourceDir().toPath().resolve(sourcePath);
    }

    private void addPatternMatchedFiles(Set<ImmutableTranspilation.Builder> sourceFiles) {
        if (!this.babelMojo.getJsSourceIncludes().isEmpty()) {
            Stream.of(this.getIncludesDirectoryScanner().getIncludedFiles()).map(this::resolveAgainstSourceDirectory).map(this::toTranspilationBuilder).forEach(sourceFiles::add);
        }
    }

    private ImmutableTranspilation.Builder toTranspilationBuilder(Path sourceFile) {
        return ImmutableTranspilation.builder().source(sourceFile).target(this.determineTargetPath(sourceFile));
    }

    private String getFormattedPresets(BabelMojo mojo) {
        return Stream.of(mojo.getPresets().split(",")).map(String::trim).map(preset -> String.format("'%s'", preset)).collect(Collectors.joining(","));
    }

    private Path determineTargetPath(Path sourceFile) {
        Path relativePath = this.getRelativePath(sourceFile);
        String prefix = this.babelMojo.getPrefix() == null ? "" : this.babelMojo.getPrefix();
        return this.babelMojo.getTargetDir().toPath().resolve(relativePath).resolve(prefix + sourceFile.getFileName());
    }

    private String removeLeadingSlash(String subject) {
        if (subject.startsWith(File.separator) || subject.startsWith("/")) {
            return subject.substring(1);
        }
        return subject;
    }

    private DirectoryScanner getIncludesDirectoryScanner() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(this.checkFileSeparator(this.babelMojo.getJsSourceIncludes()));
        scanner.setExcludes(this.checkFileSeparator(this.babelMojo.getJsSourceExcludes()));
        scanner.addDefaultExcludes();
        scanner.setBasedir(this.babelMojo.getSourceDir());
        scanner.scan();
        return scanner;
    }

    private String[] checkFileSeparator(List<String> paths) {
        return (String[])paths.stream().map(path -> {
            if (File.separatorChar != '/' && path.contains("/")) {
                return path.replace("/", File.separator);
            }
            return path;
        }).map(this::removeLeadingSlash).toArray(String[]::new);
    }

    private Path getRelativePath(Path sourceFile) {
        return Paths.get(this.babelMojo.getSourceDir().toURI().relativize(sourceFile.getParent().toFile().toURI()).getPath(), new String[0]);
    }
}

