/*
 * Decompiled with CFR 0.152.
 */
package com.jarslab.maven.babel.plugin.transpiler;

import com.jarslab.maven.babel.plugin.transpiler.ImmutableTranspilation;
import com.jarslab.maven.babel.plugin.transpiler.Transpilation;
import com.jarslab.maven.babel.plugin.transpiler.TranspilationContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.maven.plugin.logging.Log;

public class BabelTranspiler {
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    private static final String INPUT_VARIABLE = "input";
    private static final String BABEL_EXECUTE = "Babel.transform(%s, {presets: [%s]}).code";
    private TranspilationContext context;
    private ScriptEngine engine;
    private SimpleBindings simpleBindings;

    private void initialize(TranspilationContext context) {
        Objects.requireNonNull(context);
        if (this.context == null || !this.context.equals(context)) {
            this.context = context;
            this.createEngine();
        }
    }

    private void createEngine() {
        this.context.getLog().debug((CharSequence)"Initializing script engine");
        try (InputStreamReader babelReader = new InputStreamReader((InputStream)new FileInputStream(this.context.getBabelSource()), this.context.getCharset());){
            this.engine = new ScriptEngineManager(null).getEngineByMimeType(JAVASCRIPT_MIME_TYPE);
            this.simpleBindings = new SimpleBindings();
            this.engine.eval((Reader)babelReader, (Bindings)this.simpleBindings);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Transpilation execute(Transpilation transpilation) {
        this.initialize(transpilation.getContext());
        Log log = this.context.getLog();
        if (this.context.isVerbose()) {
            log.info((CharSequence)String.format("Transpiling %s -> %s", transpilation.getSource(), transpilation.getTarget()));
        }
        try {
            String source = Files.lines(transpilation.getSource(), this.context.getCharset()).collect(Collectors.joining(System.lineSeparator()));
            this.simpleBindings.put(INPUT_VARIABLE, (Object)source);
            String result = (String)this.engine.eval(String.format(BABEL_EXECUTE, INPUT_VARIABLE, this.context.getPresets()), (Bindings)this.simpleBindings);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)String.format("%s result:\n%s", transpilation.getTarget(), result));
            }
            return ImmutableTranspilation.copyOf(transpilation).withResult(result);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }
}

