/*
 * Decompiled with CFR 0.152.
 */
package com.jarslab.maven.babel.plugin.transpiler;

import com.jarslab.maven.babel.plugin.transpiler.Transpilation;
import com.jarslab.maven.babel.plugin.transpiler.TranspilationContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="Transpilation", generator="Immutables")
public final class ImmutableTranspilation
implements Transpilation {
    private final TranspilationContext context;
    private final Path source;
    private final Path target;
    private final String result;

    private ImmutableTranspilation(TranspilationContext context, Path source, Path target, String result) {
        this.context = context;
        this.source = source;
        this.target = target;
        this.result = result;
    }

    @Override
    public TranspilationContext getContext() {
        return this.context;
    }

    @Override
    public Path getSource() {
        return this.source;
    }

    @Override
    public Path getTarget() {
        return this.target;
    }

    @Override
    public Optional<String> getResult() {
        return Optional.ofNullable(this.result);
    }

    public final ImmutableTranspilation withContext(TranspilationContext value) {
        if (this.context == value) {
            return this;
        }
        TranspilationContext newValue = Objects.requireNonNull(value, "context");
        return new ImmutableTranspilation(newValue, this.source, this.target, this.result);
    }

    public final ImmutableTranspilation withSource(Path value) {
        if (this.source == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "source");
        return new ImmutableTranspilation(this.context, newValue, this.target, this.result);
    }

    public final ImmutableTranspilation withTarget(Path value) {
        if (this.target == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "target");
        return new ImmutableTranspilation(this.context, this.source, newValue, this.result);
    }

    public final ImmutableTranspilation withResult(String value) {
        String newValue = Objects.requireNonNull(value, "result");
        if (Objects.equals(this.result, newValue)) {
            return this;
        }
        return new ImmutableTranspilation(this.context, this.source, this.target, newValue);
    }

    public final ImmutableTranspilation withResult(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.result, value)) {
            return this;
        }
        return new ImmutableTranspilation(this.context, this.source, this.target, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTranspilation && this.equalTo((ImmutableTranspilation)another);
    }

    private boolean equalTo(ImmutableTranspilation another) {
        return this.context.equals(another.context) && this.source.equals(another.source) && this.target.equals(another.target) && Objects.equals(this.result, another.result);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.target.hashCode();
        h += (h << 5) + Objects.hashCode(this.result);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Transpilation{");
        builder.append("context=").append(this.context);
        builder.append(", ");
        builder.append("source=").append(this.source);
        builder.append(", ");
        builder.append("target=").append(this.target);
        if (this.result != null) {
            builder.append(", ");
            builder.append("result=").append(this.result);
        }
        return builder.append("}").toString();
    }

    public static ImmutableTranspilation copyOf(Transpilation instance) {
        if (instance instanceof ImmutableTranspilation) {
            return (ImmutableTranspilation)instance;
        }
        return ImmutableTranspilation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Transpilation", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONTEXT = 1L;
        private static final long INIT_BIT_SOURCE = 2L;
        private static final long INIT_BIT_TARGET = 4L;
        private long initBits = 7L;
        private TranspilationContext context;
        private Path source;
        private Path target;
        private String result;

        private Builder() {
        }

        public final Builder from(Transpilation instance) {
            Objects.requireNonNull(instance, "instance");
            this.context(instance.getContext());
            this.source(instance.getSource());
            this.target(instance.getTarget());
            Optional<String> resultOptional = instance.getResult();
            if (resultOptional.isPresent()) {
                this.result(resultOptional);
            }
            return this;
        }

        public final Builder context(TranspilationContext context) {
            this.context = Objects.requireNonNull(context, "context");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder source(Path source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder target(Path target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder result(String result) {
            this.result = Objects.requireNonNull(result, "result");
            return this;
        }

        public final Builder result(Optional<String> result) {
            this.result = result.orElse(null);
            return this;
        }

        public ImmutableTranspilation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTranspilation(this.context, this.source, this.target, this.result);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("context");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("target");
            }
            return "Cannot build Transpilation, some of required attributes are not set " + attributes;
        }
    }
}

