/*
 * Decompiled with CFR 0.152.
 */
package com.jarslab.maven.babel.plugin.transpiler;

import com.jarslab.maven.babel.plugin.transpiler.TranspilationContext;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import org.immutables.value.Generated;

@Generated(from="TranspilationContext", generator="Immutables")
public final class ImmutableTranspilationContext
implements TranspilationContext {
    private final File babelSource;
    private final Charset charset;
    private final Log log;
    private final boolean isVerbose;
    private final String presets;

    private ImmutableTranspilationContext(Builder builder) {
        this.babelSource = builder.babelSource;
        this.charset = builder.charset;
        this.log = builder.log;
        this.presets = builder.presets;
        this.isVerbose = builder.isVerboseIsSet() ? builder.isVerbose : TranspilationContext.super.isVerbose();
    }

    private ImmutableTranspilationContext(File babelSource, Charset charset, Log log, boolean isVerbose, String presets) {
        this.babelSource = babelSource;
        this.charset = charset;
        this.log = log;
        this.isVerbose = isVerbose;
        this.presets = presets;
    }

    @Override
    public File getBabelSource() {
        return this.babelSource;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public boolean isVerbose() {
        return this.isVerbose;
    }

    @Override
    public String getPresets() {
        return this.presets;
    }

    public final ImmutableTranspilationContext withBabelSource(File value) {
        if (this.babelSource == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "babelSource");
        return new ImmutableTranspilationContext(newValue, this.charset, this.log, this.isVerbose, this.presets);
    }

    public final ImmutableTranspilationContext withCharset(Charset value) {
        if (this.charset == value) {
            return this;
        }
        Charset newValue = Objects.requireNonNull(value, "charset");
        return new ImmutableTranspilationContext(this.babelSource, newValue, this.log, this.isVerbose, this.presets);
    }

    public final ImmutableTranspilationContext withLog(Log value) {
        if (this.log == value) {
            return this;
        }
        Log newValue = Objects.requireNonNull(value, "log");
        return new ImmutableTranspilationContext(this.babelSource, this.charset, newValue, this.isVerbose, this.presets);
    }

    public final ImmutableTranspilationContext withIsVerbose(boolean value) {
        if (this.isVerbose == value) {
            return this;
        }
        return new ImmutableTranspilationContext(this.babelSource, this.charset, this.log, value, this.presets);
    }

    public final ImmutableTranspilationContext withPresets(String value) {
        String newValue = Objects.requireNonNull(value, "presets");
        if (this.presets.equals(newValue)) {
            return this;
        }
        return new ImmutableTranspilationContext(this.babelSource, this.charset, this.log, this.isVerbose, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTranspilationContext && this.equalTo((ImmutableTranspilationContext)another);
    }

    private boolean equalTo(ImmutableTranspilationContext another) {
        return this.babelSource.equals(another.babelSource) && this.charset.equals(another.charset) && this.log.equals(another.log) && this.isVerbose == another.isVerbose && this.presets.equals(another.presets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.babelSource.hashCode();
        h += (h << 5) + this.charset.hashCode();
        h += (h << 5) + this.log.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isVerbose);
        h += (h << 5) + this.presets.hashCode();
        return h;
    }

    public String toString() {
        return "TranspilationContext{babelSource=" + this.babelSource + ", charset=" + this.charset + ", log=" + this.log + ", isVerbose=" + this.isVerbose + ", presets=" + this.presets + "}";
    }

    public static ImmutableTranspilationContext copyOf(TranspilationContext instance) {
        if (instance instanceof ImmutableTranspilationContext) {
            return (ImmutableTranspilationContext)instance;
        }
        return ImmutableTranspilationContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TranspilationContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_BABEL_SOURCE = 1L;
        private static final long INIT_BIT_CHARSET = 2L;
        private static final long INIT_BIT_LOG = 4L;
        private static final long INIT_BIT_PRESETS = 8L;
        private static final long OPT_BIT_IS_VERBOSE = 1L;
        private long initBits = 15L;
        private long optBits;
        private File babelSource;
        private Charset charset;
        private Log log;
        private boolean isVerbose;
        private String presets;

        private Builder() {
        }

        public final Builder from(TranspilationContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.babelSource(instance.getBabelSource());
            this.charset(instance.getCharset());
            this.log(instance.getLog());
            this.isVerbose(instance.isVerbose());
            this.presets(instance.getPresets());
            return this;
        }

        public final Builder babelSource(File babelSource) {
            this.babelSource = Objects.requireNonNull(babelSource, "babelSource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder charset(Charset charset) {
            this.charset = Objects.requireNonNull(charset, "charset");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder log(Log log) {
            this.log = Objects.requireNonNull(log, "log");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder isVerbose(boolean isVerbose) {
            this.isVerbose = isVerbose;
            this.optBits |= 1L;
            return this;
        }

        public final Builder presets(String presets) {
            this.presets = Objects.requireNonNull(presets, "presets");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTranspilationContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTranspilationContext(this);
        }

        private boolean isVerboseIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("babelSource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("charset");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("log");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("presets");
            }
            return "Cannot build TranspilationContext, some of required attributes are not set " + attributes;
        }
    }
}

