/*
 * Decompiled with CFR 0.152.
 */
package com.jarslab.maven.babel.plugin.transpiler;

import com.jarslab.maven.babel.plugin.transpiler.BabelTranspiler;
import com.jarslab.maven.babel.plugin.transpiler.BabelTranspilerStrategy;
import com.jarslab.maven.babel.plugin.transpiler.Transpilation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;

class ParallelBabelTranspilerStrategy
implements BabelTranspilerStrategy {
    private final Log log;
    private final int threads;

    ParallelBabelTranspilerStrategy(Log log, int threads) {
        this.log = Objects.requireNonNull(log);
        this.threads = this.getAvailableThreads(threads);
    }

    @Override
    public Stream<Transpilation> execute(Set<Transpilation> transpilations) {
        ConcurrentLinkedQueue<Transpilation> queue = new ConcurrentLinkedQueue<Transpilation>(transpilations);
        Supplier<Collection> task = () -> {
            Transpilation transpilation;
            BabelTranspiler transpiler = new BabelTranspiler();
            HashSet<Transpilation> transpiled = new HashSet<Transpilation>();
            while ((transpilation = (Transpilation)queue.poll()) != null) {
                if (this.log.isDebugEnabled()) {
                    String name = Thread.currentThread().getName();
                    this.log.debug((CharSequence)String.format("[%s] transpiling %s", name, transpilation.getSource()));
                }
                transpiled.add(transpiler.execute(transpilation));
            }
            return transpiled;
        };
        HashSet<CompletableFuture<Collection>> futures = new HashSet<CompletableFuture<Collection>>();
        for (int i = 0; i < this.threads; ++i) {
            futures.add(CompletableFuture.supplyAsync(task));
        }
        return futures.stream().map(CompletableFuture::join).flatMap(Collection::stream);
    }

    private int getAvailableThreads(int threads) {
        int availableThreads = Runtime.getRuntime().availableProcessors();
        if (threads < 1) {
            this.log.warn((CharSequence)String.format("Invalid number of threads (%d). Setting number of threads to 1", threads));
            return 1;
        }
        if (threads > availableThreads) {
            this.log.warn((CharSequence)String.format("Configured number of threads (%d) exceeds the number of available processors (%d), setting number of threads to %2$d", threads, availableThreads));
            return availableThreads;
        }
        return threads;
    }
}

