/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.impl;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.Mode;
import com.jayway.jsonpath.spi.impl.AbstractJsonProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JsonSmartJsonProvider
extends AbstractJsonProvider {
    private Mode mode;
    private ContainerFactory containerFactory = ContainerFactory.FACTORY_SIMPLE;

    public JsonSmartJsonProvider() {
        this(Mode.SLACK);
    }

    public JsonSmartJsonProvider(Mode mode) {
        this.mode = mode;
    }

    @Override
    public Map<String, Object> createMap() {
        return this.containerFactory.createObjectContainer();
    }

    @Override
    public List<Object> createArray() {
        return this.containerFactory.createArrayContainer();
    }

    @Override
    public Object parse(String json) {
        try {
            return this.createParser().parse(json, this.containerFactory);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(Reader jsonReader) throws InvalidJsonException {
        try {
            return this.createParser().parse(jsonReader, this.containerFactory);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream) throws InvalidJsonException {
        try {
            return this.createParser().parse((Reader)new InputStreamReader(jsonStream), this.containerFactory);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (obj instanceof Map) {
            return JSONObject.toJSONString((Map)((Map)obj));
        }
        if (obj instanceof List) {
            return JSONArray.toJSONString((List)((List)obj));
        }
        throw new UnsupportedOperationException(obj.getClass().getName() + " can not be converted to JSON");
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }

    private JSONParser createParser() {
        return new JSONParser(this.mode.intValue());
    }
}

