/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.formatter;

import com.jgoodies.validation.formatter.EmptyDateFormatter;
import com.jgoodies.validation.util.ValidationUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RelativeDateFormatter
extends EmptyDateFormatter {
    public static final String KEY_YESTERDAY = "RelativeDate.yesterday";
    public static final String KEY_TODAY = "RelativeDate.today";
    public static final String KEY_TOMORROW = "RelativeDate.tomorrow";
    private static ResourceBundle defaultResourceBundle;
    private final boolean useOutputShortcuts;
    private final boolean allowRelativeInput;
    private ResourceBundle resourceBundle;

    public RelativeDateFormatter() {
        this(true, true);
    }

    public RelativeDateFormatter(DateFormat format) {
        this(format, true, true);
    }

    public RelativeDateFormatter(boolean useOutputShortcuts, boolean allowRelativeInput) {
        this.useOutputShortcuts = useOutputShortcuts;
        this.allowRelativeInput = allowRelativeInput;
    }

    public RelativeDateFormatter(DateFormat format, boolean useOutputShortcuts, boolean allowRelativeInput) {
        super(format);
        this.useOutputShortcuts = useOutputShortcuts;
        this.allowRelativeInput = allowRelativeInput;
    }

    public Object stringToValue(String text) throws ParseException {
        if (!this.allowRelativeInput) {
            return super.stringToValue(text);
        }
        if (text.startsWith("+")) {
            text = text.substring(1);
        }
        try {
            int offsetDays = Integer.parseInt(text);
            return ValidationUtils.getRelativeDate(offsetDays);
        }
        catch (NumberFormatException e) {
            return super.stringToValue(text);
        }
    }

    public String valueToString(Object value) throws ParseException {
        if (value == null || !this.useOutputShortcuts || !(value instanceof Date)) {
            return super.valueToString(value);
        }
        Date date = (Date)value;
        if (ValidationUtils.isYesterday(date)) {
            return this.getString(KEY_YESTERDAY);
        }
        if (ValidationUtils.isToday(date)) {
            return this.getString(KEY_TODAY);
        }
        if (ValidationUtils.isTomorrow(date)) {
            return this.getString(KEY_TOMORROW);
        }
        return super.valueToString(value);
    }

    public static ResourceBundle getDefaultResourceBundle() {
        if (defaultResourceBundle == null) {
            defaultResourceBundle = new DefaultResources();
        }
        return defaultResourceBundle;
    }

    public static void setDefaultResourceBundle(ResourceBundle newDefaultBundle) {
        defaultResourceBundle = newDefaultBundle;
    }

    public final ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public final void setResourceBundle(ResourceBundle newBundle) {
        this.resourceBundle = newBundle;
    }

    private String getString(String key) {
        ResourceBundle bundle = this.getResourceBundle();
        if (bundle == null) {
            bundle = RelativeDateFormatter.getDefaultResourceBundle();
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "RelativeDateFormatter", e);
            return "";
        }
    }

    private static final class DefaultResources
    extends ListResourceBundle {
        private static final Object[][] CONTENTS = new Object[][]{{"RelativeDate.yesterday", "Yesterday"}, {"RelativeDate.today", "Today"}, {"RelativeDate.tomorrow", "Tomorrow"}};

        private DefaultResources() {
        }

        public Object[][] getContents() {
            return CONTENTS;
        }
    }
}

