/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.jupiter.tools.spring.test.mongo.internal.expect.dynamic.value.DynamicValue;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyDynamicValue
implements DynamicValue {
    private final ScriptEngine engine;
    private final Logger log = LoggerFactory.getLogger(GroovyDynamicValue.class);

    public GroovyDynamicValue() {
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName("groovy");
    }

    @Override
    public boolean isNecessary(Object value) {
        return value instanceof String && ((String)value).startsWith("groovy:");
    }

    @Override
    public Object evaluate(Object value) {
        try {
            return this.engine.eval((String)value);
        }
        catch (ScriptException e) {
            this.log.error("Groovy engine evaluate error: ", (Throwable)e);
            throw new InternalException("Groovy engine evaluate error", Integer.valueOf(102), (Throwable)e);
        }
    }
}

