/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.graph;

import com.jupiter.tools.spring.test.mongo.internal.expect.graph.Graph;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IndexedGraph
implements Graph {
    private final Graph graph;
    private boolean indexReady;
    private Set<Integer> patternIndexes;
    private Set<Integer> dataIndexes;

    public IndexedGraph(Graph graph) {
        this.graph = graph;
        this.dataIndexes = new HashSet<Integer>();
        this.patternIndexes = new HashSet<Integer>();
    }

    @Override
    public boolean[][] calculate() {
        return this.graph.calculate();
    }

    @Override
    public int dataCount() {
        return this.graph.dataCount();
    }

    @Override
    public int patternCount() {
        return this.graph.patternCount();
    }

    @Override
    public Map<String, Object> getDataRecord(int index) {
        return this.graph.getDataRecord(index);
    }

    @Override
    public Map<String, Object> getPattern(int index) {
        return this.graph.getPattern(index);
    }

    @Override
    public String getDocumentName() {
        return this.graph.getDocumentName();
    }

    public Set<Integer> evaluatePatternIndexes() {
        if (!this.indexReady) {
            this.evaluateIndexes();
        }
        return this.patternIndexes;
    }

    public Set<Integer> evaluateDataIndexes() {
        if (!this.indexReady) {
            this.evaluateIndexes();
        }
        return this.dataIndexes;
    }

    private void evaluateIndexes() {
        boolean[][] matrix = this.graph.calculate();
        for (int i = 0; i < this.dataCount(); ++i) {
            for (int j = 0; j < this.patternCount(); ++j) {
                if (!matrix[i][j]) continue;
                this.dataIndexes.add(i);
                this.patternIndexes.add(j);
            }
        }
        this.indexReady = true;
    }
}

