/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.match;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.MatchData;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.simple.MatchDataFactory;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.MatchDataSmartFactory;

public class MatchAny
implements MatchData {
    private final MatchDataFactory matchDataFactory = new MatchDataFactory();
    private final MatchDataSmartFactory matchDataSmartFactory = new MatchDataSmartFactory();

    @Override
    public boolean match(Object original, Object expected) {
        if (this.matchDataSmartFactory.isNecessary(expected)) {
            return this.matchDataSmartFactory.get(expected).match(original, expected);
        }
        return this.simpleMatch(original, expected);
    }

    private boolean simpleMatch(Object original, Object expected) {
        JsonNode originalNode = new ObjectMapper().valueToTree(original);
        JsonNode expectedNode = new ObjectMapper().valueToTree(expected);
        if (original == null) {
            return expected == null;
        }
        if (expected == null) {
            return true;
        }
        if (originalNode.getNodeType() != expectedNode.getNodeType()) {
            return false;
        }
        return this.matchDataFactory.get(originalNode.getNodeType()).match(original, expected);
    }
}

