/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.match.simple;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.MatchData;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.simple.MatchBigInteger;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.simple.MatchDouble;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.simple.MatchLong;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.simple.MatchObjects;

public class MatchNumber
implements MatchData {
    private final MatchObjects matchObjects = new MatchObjects();
    private final MatchLong matchLong = new MatchLong();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final MatchBigInteger matchBigInteger = new MatchBigInteger();
    private final MatchDouble matchDouble = new MatchDouble();

    @Override
    public boolean match(Object original, Object expected) {
        JsonParser.NumberType originalType = this.objectMapper.valueToTree(original).numberType();
        JsonParser.NumberType expectedType = this.objectMapper.valueToTree(expected).numberType();
        if (originalType == JsonParser.NumberType.INT || originalType == JsonParser.NumberType.LONG) {
            return this.matchLong.match(original, expected);
        }
        if (originalType == JsonParser.NumberType.DOUBLE || originalType == JsonParser.NumberType.FLOAT) {
            return this.matchDouble.match(original, expected);
        }
        if (originalType == JsonParser.NumberType.BIG_INTEGER || expectedType == JsonParser.NumberType.BIG_INTEGER) {
            return this.matchBigInteger.match(original, expected);
        }
        return this.matchObjects.match(original, expected);
    }
}

