/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.date;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.date.TimeDirection;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.date.TimeOperation;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeDescription {
    private static final String TIME_DESCRIPTION_PATTERN = "^(\\[NOW\\])((\\+|\\-)([0-9]{1,7})(\\((DAYS|HOURS|MINUTES|SECONDS)\\))){0,1}(\\{THR=([0-9]{1,10})\\}){0,1}$";
    private static final int DEFAULT_THRESHOLD = 10000;
    private final String description;
    private Integer threshold = null;

    public TimeDescription(String description) {
        this.description = description;
    }

    public TimeOperation getTimeOperation() {
        Matcher matcher = this.matchTimeDescriptionPattern(this.description);
        if (this.parseTimeOperation(matcher) == null) {
            return new TimeOperation(TimeDirection.UNDEFINED, null, 0);
        }
        TimeDirection direction = this.parseDirection(matcher);
        int count = this.parseCount(matcher);
        TimeUnit unit = this.parseTimeUnit(matcher);
        this.threshold = this.parseThreshold(matcher);
        return new TimeOperation(direction, unit, count);
    }

    private Matcher matchTimeDescriptionPattern(String value) {
        Pattern pattern = Pattern.compile(TIME_DESCRIPTION_PATTERN);
        Matcher matcher = pattern.matcher(value);
        matcher.find();
        return matcher;
    }

    private String parseTimeOperation(Matcher matcher) {
        return matcher.group(2);
    }

    private TimeUnit parseTimeUnit(Matcher matcher) {
        return TimeUnit.valueOf(matcher.group(6));
    }

    private int parseCount(Matcher matcher) {
        return Integer.valueOf(matcher.group(4));
    }

    private TimeDirection parseDirection(Matcher matcher) {
        switch (matcher.group(3)) {
            case "+": {
                return TimeDirection.PLUS;
            }
            case "-": {
                return TimeDirection.MINUS;
            }
        }
        throw new InternalException("unsupported operation", Integer.valueOf(106));
    }

    public boolean matches() {
        Matcher matcher = this.matchTimeDescriptionPattern(this.description);
        return matcher.matches();
    }

    public long getThreshold() {
        if (this.threshold == null) {
            Matcher matcher = this.matchTimeDescriptionPattern(this.description);
            this.threshold = this.parseThreshold(matcher);
        }
        return this.threshold.intValue();
    }

    private Integer parseThreshold(Matcher matcher) {
        this.threshold = matcher.group(8) != null ? Integer.valueOf(matcher.group(8)) : 10000;
        return this.threshold;
    }
}

