/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.groovy;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.MatchDataSmart;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchGroovy
implements MatchDataSmart {
    private static final String PREFIX = "groovy-match:";
    private final ScriptEngine engine;
    private final Logger log = LoggerFactory.getLogger(MatchGroovy.class);

    public MatchGroovy() {
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName("groovy");
    }

    @Override
    public boolean match(Object original, Object expected) {
        try {
            String expectedValue = ((String)expected).replaceFirst(PREFIX, "");
            this.engine.put("value", original);
            Object result = this.engine.eval(expectedValue);
            if (!(result instanceof Boolean)) {
                throw new InternalException("groovy-match: must return a boolean value instead of {" + result + "}", Integer.valueOf(106));
            }
            return (Boolean)result;
        }
        catch (ScriptException e) {
            this.log.error("Groovy engine evaluate error: ", (Throwable)e);
            throw new InternalException("Groovy engine evaluate error", Integer.valueOf(104), (Throwable)e);
        }
    }

    @Override
    public boolean isNecessary(Object expected) {
        if (!(expected instanceof String)) {
            return false;
        }
        return ((String)expected).startsWith(PREFIX);
    }
}

