/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.javascript;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.jupiter.tools.spring.test.mongo.internal.expect.match.smart.MatchDataSmart;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchJavaScript
implements MatchDataSmart {
    private static final String PREFIX = "js-match:";
    private final ScriptEngine engine;
    private final Logger log = LoggerFactory.getLogger(MatchJavaScript.class);

    public MatchJavaScript() {
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName("js");
    }

    @Override
    public boolean match(Object original, Object expected) {
        Object result = this.evaluate((String)expected, original);
        if (!(result instanceof Boolean)) {
            throw new InternalException("js-match: must return a boolean value instead of {" + result + "}", Integer.valueOf(111));
        }
        return (Boolean)result;
    }

    private Object evaluate(String script, Object value) {
        try {
            String expectedValue = script.replaceFirst(PREFIX, "");
            this.engine.put("value", value);
            return this.engine.eval(expectedValue);
        }
        catch (Throwable e) {
            throw new InternalException("JS engine evaluate error", Integer.valueOf(112), e);
        }
    }

    @Override
    public boolean isNecessary(Object expected) {
        if (!(expected instanceof String)) {
            return false;
        }
        return ((String)expected).startsWith(PREFIX);
    }
}

