/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.exportdata;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jupiter.tools.spring.test.mongo.internal.DataSet;
import com.jupiter.tools.spring.test.mongo.internal.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonExport
implements Text {
    private final DataSet dataSet;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Logger log;

    public JsonExport(DataSet dataSet) {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.dataSet = dataSet;
        this.log = LoggerFactory.getLogger(JsonExport.class);
    }

    @Override
    public String read() {
        try {
            return this.objectMapper.writeValueAsString(this.dataSet.read());
        }
        catch (Exception e) {
            this.log.error("Error while converting dataset to JSON string: ", (Throwable)e);
            throw new InternalException((Throwable)e);
        }
    }
}

