/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.exportdata.scanner;

import com.jupiter.tools.spring.test.mongo.internal.exportdata.scanner.CaseInsensitiveMap;
import com.jupiter.tools.spring.test.mongo.internal.exportdata.scanner.DocumentScanner;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mongodb.core.mapping.Document;

public class ReflectionsDocumentScanner
implements DocumentScanner {
    private final String basePackage;

    public ReflectionsDocumentScanner(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public Map<String, Class<?>> scan() {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        Reflections reflections = new Reflections(this.basePackage, new Scanner[0]);
        Set documents = reflections.getTypesAnnotatedWith(Document.class);
        for (Class doc : documents) {
            Document annotation = doc.getAnnotation(Document.class);
            String value = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"value");
            if (this.empty(value)) {
                value = annotation.collection();
            }
            if (this.empty(value)) {
                value = doc.getSimpleName().toLowerCase();
            }
            ((HashMap)result).put(value, doc);
        }
        return result;
    }

    private boolean empty(String value) {
        return value == null || "".equals(value);
    }
}

