/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.geo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPolygon;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;

public class GeoJsonSerializationModule
extends SimpleModule {
    public GeoJsonSerializationModule() {
        this.addSerializer(new GeoJsonPointSerializer());
        this.addSerializer(new GeoJsonMultiPointSerializer());
        this.addSerializer(new GeoJsonLineStringSerializer());
        this.addSerializer(new GeoJsonMultiLineStringSerializer());
        this.addSerializer(new GeoJsonPolygonSerializer());
        this.addSerializer(new GeoJsonMultiPolygonSerializer());
    }

    private class GeoJsonMultiPolygonSerializer
    extends JsonSerializer<GeoJsonMultiPolygon> {
        private GeoJsonMultiPolygonSerializer() {
        }

        public Class<GeoJsonMultiPolygon> handledType() {
            return GeoJsonMultiPolygon.class;
        }

        public void serialize(GeoJsonMultiPolygon value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType());
            gen.writeArrayFieldStart("coordinates");
            for (GeoJsonPolygon polygon : value.getCoordinates()) {
                gen.writeStartArray();
                for (GeoJsonLineString lines : polygon.getCoordinates()) {
                    gen.writeStartArray();
                    for (Point p : lines.getCoordinates()) {
                        gen.writeObject((Object)new double[]{p.getX(), p.getY()});
                    }
                    gen.writeEndArray();
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }

    private class GeoJsonPolygonSerializer
    extends JsonSerializer<GeoJsonPolygon> {
        private GeoJsonPolygonSerializer() {
        }

        public Class<GeoJsonPolygon> handledType() {
            return GeoJsonPolygon.class;
        }

        public void serialize(GeoJsonPolygon value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType());
            gen.writeArrayFieldStart("coordinates");
            for (GeoJsonLineString ls : value.getCoordinates()) {
                gen.writeStartArray();
                for (Point p : ls.getCoordinates()) {
                    gen.writeObject((Object)new double[]{p.getX(), p.getY()});
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }

    private class GeoJsonMultiLineStringSerializer
    extends JsonSerializer<GeoJsonMultiLineString> {
        private GeoJsonMultiLineStringSerializer() {
        }

        public Class<GeoJsonMultiLineString> handledType() {
            return GeoJsonMultiLineString.class;
        }

        public void serialize(GeoJsonMultiLineString value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType());
            gen.writeArrayFieldStart("coordinates");
            for (GeoJsonLineString line : value.getCoordinates()) {
                gen.writeStartArray();
                for (Point p : line.getCoordinates()) {
                    gen.writeObject((Object)new double[]{p.getX(), p.getY()});
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }

    private class GeoJsonLineStringSerializer
    extends JsonSerializer<GeoJsonLineString> {
        private GeoJsonLineStringSerializer() {
        }

        public Class<GeoJsonLineString> handledType() {
            return GeoJsonLineString.class;
        }

        public void serialize(GeoJsonLineString value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType());
            gen.writeArrayFieldStart("coordinates");
            for (Point p : value.getCoordinates()) {
                gen.writeObject((Object)new double[]{p.getX(), p.getY()});
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }

    private class GeoJsonMultiPointSerializer
    extends JsonSerializer<GeoJsonMultiPoint> {
        private GeoJsonMultiPointSerializer() {
        }

        public Class<GeoJsonMultiPoint> handledType() {
            return GeoJsonMultiPoint.class;
        }

        public void serialize(GeoJsonMultiPoint value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType());
            gen.writeArrayFieldStart("coordinates");
            for (Point p : value.getCoordinates()) {
                gen.writeObject((Object)new double[]{p.getX(), p.getY()});
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }

    private class GeoJsonPointSerializer
    extends JsonSerializer<GeoJsonPoint> {
        private GeoJsonPointSerializer() {
        }

        public Class<GeoJsonPoint> handledType() {
            return GeoJsonPoint.class;
        }

        public void serialize(GeoJsonPoint value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType());
            gen.writeArrayFieldStart("coordinates");
            gen.writeObject(value.getCoordinates().get(0));
            gen.writeObject(value.getCoordinates().get(1));
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }
}

