/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.importdata;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.antkorwin.commonutils.validation.ErrorInfo;
import com.jupiter.tools.spring.test.mongo.errorinfo.MongoDbErrorInfo;
import com.jupiter.tools.spring.test.mongo.internal.Text;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFile
implements Text {
    private final String fileName;
    private final Logger log = LoggerFactory.getLogger(ImportFile.class);

    public ImportFile(String fileName) {
        this.fileName = fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String read() {
        try (InputStream inputStream = this.getResourceStream();){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            this.log.error("Error while trying to read data from file: {}", (Object)this.fileName, (Object)e);
            throw new InternalException((ErrorInfo)MongoDbErrorInfo.READ_DATASETS_FILE_ERROR, (Throwable)e);
        }
    }

    private InputStream getResourceStream() throws IOException {
        String dataFileName = !this.fileName.startsWith("/") ? "/" + this.fileName : this.fileName;
        InputStream inputStream = this.getClass().getResourceAsStream(dataFileName);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream("/dataset" + dataFileName);
        }
        if (inputStream == null) {
            inputStream = Files.newInputStream(Paths.get(this.fileName, new String[0]), new OpenOption[0]);
        }
        return inputStream;
    }
}

