/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.internal.importdata;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.antkorwin.commonutils.validation.ErrorInfo;
import com.antkorwin.commonutils.validation.Guard;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jupiter.tools.spring.test.mongo.errorinfo.MongoDbErrorInfo;
import com.jupiter.tools.spring.test.mongo.internal.DataSet;
import com.jupiter.tools.spring.test.mongo.internal.importdata.DataSetImport;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.geo.GeoJsonModule;

public class MongoDataImport
implements DataSetImport {
    private final MongoTemplate mongoTemplate;
    private final ObjectMapper objectMapper;
    private final Logger log = LoggerFactory.getLogger(MongoDataImport.class);

    public MongoDataImport(MongoTemplate mongoTemplate) {
        Guard.check((mongoTemplate != null ? 1 : 0) != 0, InternalException.class, (ErrorInfo)MongoDbErrorInfo.MONGO_TEMPLATE_IS_MANDATORY);
        this.mongoTemplate = mongoTemplate;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new GeoJsonModule());
    }

    @Override
    public void importFrom(DataSet dataSet) {
        dataSet.read().forEach((key, values) -> this.importDocumentCollection(this.mongoTemplate, this.getDocumentClassByName((String)key), (List<?>)values));
    }

    private <T> void importDocumentCollection(MongoTemplate mongoTemplate, Class<T> documentClassType, List<?> recordCollection) {
        recordCollection.forEach(document -> {
            try {
                Object typedDocument = this.objectMapper.convertValue(document, documentClassType);
                mongoTemplate.save(typedDocument);
            }
            catch (Exception e) {
                this.log.error("Error while trying to convert Object: {} to: {}", new Object[]{document, documentClassType, e});
                throw new InternalException((ErrorInfo)MongoDbErrorInfo.DOCUMENT_RECORD_PARSING_ERROR, (Throwable)e);
            }
        });
    }

    private Class<?> getDocumentClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.log.error("Unresolved document collection class reference: {}", (Object)className, (Object)e);
            throw new InternalException((ErrorInfo)MongoDbErrorInfo.UNRESOLVED_DOCUMENT_COLLECTION_CLASS_TYPE, (Throwable)e);
        }
    }
}

