/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.junit4;

import com.antkorwin.commonutils.exceptions.InternalException;
import com.antkorwin.commonutils.validation.ErrorInfo;
import com.antkorwin.commonutils.validation.Guard;
import com.jupiter.tools.spring.test.mongo.annotation.ExpectedMongoDataSet;
import com.jupiter.tools.spring.test.mongo.annotation.ExportMongoDataSet;
import com.jupiter.tools.spring.test.mongo.annotation.MongoDataSet;
import com.jupiter.tools.spring.test.mongo.errorinfo.MongoDbErrorInfo;
import com.jupiter.tools.spring.test.mongo.internal.MongoDbTest;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoDbRule
implements TestRule {
    private MongoTemplate mongoTemplate;
    private Supplier<MongoTemplate> mongoTemplateProvider;
    private String initialDataSetFilePath;

    public MongoDbRule(Supplier<MongoTemplate> templateProvider) {
        this.mongoTemplateProvider = templateProvider;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                MongoDbRule.this.mongoTemplate = (MongoTemplate)MongoDbRule.this.mongoTemplateProvider.get();
                Guard.check((MongoDbRule.this.mongoTemplate != null ? 1 : 0) != 0, InternalException.class, (ErrorInfo)MongoDbErrorInfo.MONGO_TEMPLATE_IS_MANDATORY);
                MongoDbRule.this.beforeInvocation(description);
                base.evaluate();
                MongoDbRule.this.afterInvocation(description);
            }
        };
    }

    private void beforeInvocation(Description description) {
        MongoDataSet mongoDataSet = (MongoDataSet)description.getAnnotation(MongoDataSet.class);
        if (mongoDataSet == null) {
            return;
        }
        if (mongoDataSet.cleanBefore()) {
            this.cleanDataBase();
        }
        if (!mongoDataSet.value().isEmpty()) {
            new MongoDbTest(this.mongoTemplate).importFrom(mongoDataSet.value());
        }
        if (this.isReadOnlyDataSet(description)) {
            File tempFile;
            try {
                tempFile = File.createTempFile("mongo-test-", "-readonly");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Error while creating temp file to store immutable dataset", e);
            }
            tempFile.deleteOnExit();
            new MongoDbTest(this.mongoTemplate).exportTo(tempFile.getAbsolutePath());
            this.initialDataSetFilePath = tempFile.getAbsolutePath();
        }
    }

    private void afterInvocation(Description description) {
        this.expectedDataSet(description);
        this.exportDataSet(description);
        this.cleanAfter(description);
    }

    private void expectedDataSet(Description description) {
        if (this.isReadOnlyDataSet(description)) {
            try {
                new MongoDbTest(this.mongoTemplate).expect(this.initialDataSetFilePath);
            }
            catch (Error e) {
                throw new RuntimeException("Expected ReadOnly dataset, but found some modifications:", e);
            }
            return;
        }
        ExpectedMongoDataSet expectedMongoDataSet = (ExpectedMongoDataSet)description.getAnnotation(ExpectedMongoDataSet.class);
        if (expectedMongoDataSet == null) {
            return;
        }
        new MongoDbTest(this.mongoTemplate).expect(expectedMongoDataSet.value());
    }

    private void exportDataSet(Description description) {
        ExportMongoDataSet exportMongoDataSet = (ExportMongoDataSet)description.getAnnotation(ExportMongoDataSet.class);
        if (exportMongoDataSet == null) {
            return;
        }
        new MongoDbTest(this.mongoTemplate).exportTo(exportMongoDataSet.outputFile());
    }

    private void cleanAfter(Description description) {
        MongoDataSet mongoDataSet = (MongoDataSet)description.getAnnotation(MongoDataSet.class);
        if (mongoDataSet != null && mongoDataSet.cleanAfter()) {
            this.cleanDataBase();
        }
    }

    private void cleanDataBase() {
        this.mongoTemplate.getCollectionNames().forEach(arg_0 -> ((MongoTemplate)this.mongoTemplate).dropCollection(arg_0));
    }

    private boolean isReadOnlyDataSet(Description description) {
        MongoDataSet mongoDataSet = (MongoDataSet)description.getAnnotation(MongoDataSet.class);
        return mongoDataSet != null && mongoDataSet.readOnly();
    }
}

