/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.mongo.junit5;

import com.antkorwin.commonutils.exceptions.InternalException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.junit.jupiter.api.extension.Extension;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.Transferable;

public class MongoDbTcExtension
implements Extension {
    private static final Integer MONGO_PORT = 27017;

    private static void executeInContainer(GenericContainer container, String command) {
        byte[] contentBytes = command.getBytes(StandardCharsets.UTF_8);
        String shellFilePath = "/etc/mongo-" + UUID.randomUUID().toString();
        try {
            container.copyFileToContainer(Transferable.of((byte[])contentBytes), shellFilePath);
            container.execInContainer(new String[]{"/bin/bash", shellFilePath});
        }
        catch (Exception exc) {
            throw new InternalException((Throwable)exc);
        }
    }

    static {
        System.out.println("Start MongoDb testcontainers extension...\n");
        GenericContainer mongo = new GenericContainer("mongo:latest").withCommand("mongod --bind_ip_all --replSet rs0").withExposedPorts(new Integer[]{MONGO_PORT});
        mongo.start();
        MongoDbTcExtension.executeInContainer(mongo, "mongo --eval \"rs.initiate()\" || \"rs.status().ok\"");
        MongoDbTcExtension.executeInContainer(mongo, "until mongo --eval \"printjson(rs.isMaster())\" | grep ismaster | grep true > /dev/null 2>&1;do sleep 1;done");
        System.setProperty("spring.data.mongodb.host", mongo.getContainerIpAddress());
        System.setProperty("spring.data.mongodb.port", mongo.getMappedPort(MONGO_PORT.intValue()).toString());
        System.setProperty("spring.data.mongodb.replicaSet", "rs0");
    }
}

