/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.LockSupport;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@IgnoreJRERequirement
public final class ThreadUtil {
    private static final ThreadLocal<Boolean> TREAT_AS_VIRTUAL_THREAD = new ThreadLocal();

    private ThreadUtil() {
        throw new IllegalStateException("No instances");
    }

    private static boolean isTreatAsVirtualThread() {
        return Boolean.TRUE.equals(TREAT_AS_VIRTUAL_THREAD.get());
    }

    public static void setTreatAsVirtualThread(boolean b) {
        if (ThreadUtil.isVirtualThread()) {
            return;
        }
        TREAT_AS_VIRTUAL_THREAD.set(b);
    }

    public static boolean isVirtualThread() {
        return Thread.currentThread().isVirtual() || ThreadUtil.isTreatAsVirtualThread();
    }

    public static boolean isVirtualThreadSupported() {
        return true;
    }

    public static ExecutorService newVirtualThreadPerTaskExecutor() {
        return Executors.newVirtualThreadPerTaskExecutor();
    }

    public static boolean checkNotInterruptedOrThrow() throws InterruptedIOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException();
        }
        return true;
    }

    public static Thread startNewDaemonThread(boolean virtual, Runnable run) {
        if (virtual) {
            return Thread.ofVirtual().start(run);
        }
        return Thread.ofPlatform().daemon(true).start(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnSystemThread(Runnable op) throws InterruptedException {
        if (ThreadUtil.isVirtualThread()) {
            Thread vt = Thread.currentThread();
            CompletableFuture<Void> cf = CompletableFuture.runAsync(() -> {
                try {
                    op.run();
                }
                finally {
                    LockSupport.unpark(vt);
                }
            });
            LockSupport.park();
            try {
                cf.get();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalStateException(e);
            }
        }
        boolean treatAsVirtual = ThreadUtil.isTreatAsVirtualThread();
        if (treatAsVirtual) {
            ThreadUtil.setTreatAsVirtualThread(false);
        }
        try {
            op.run();
        }
        finally {
            if (treatAsVirtual) {
                ThreadUtil.setTreatAsVirtualThread(treatAsVirtual);
            }
        }
    }
}

