/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.json;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import unirest.shaded.com.google.gson.Gson;
import unirest.shaded.com.google.gson.GsonBuilder;
import unirest.shaded.com.google.gson.TypeAdapter;
import unirest.shaded.com.google.gson.internal.LinkedTreeMap;
import unirest.shaded.com.google.gson.stream.JsonReader;
import unirest.shaded.com.google.gson.stream.JsonToken;
import unirest.shaded.com.google.gson.stream.JsonWriter;

class CoreFactory {
    private static final TypeAdapter<Object> ADAPTER = new JavaTypeAdapter();

    CoreFactory() {
    }

    static GsonBuilder getCore() {
        return new GsonBuilder().disableHtmlEscaping().serializeNulls().registerTypeAdapter((Type)((Object)Map.class), ADAPTER).registerTypeAdapter((Type)((Object)List.class), ADAPTER);
    }

    static class JavaTypeAdapter
    extends TypeAdapter<Object> {
        private final TypeAdapter<Object> delegate = new Gson().getAdapter(Object.class);

        JavaTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, Object value) throws IOException {
            this.delegate.write(out, value);
        }

        @Override
        public Object read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    ArrayList<Object> list = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        list.add(this.read(in));
                    }
                    in.endArray();
                    return list;
                }
                case BEGIN_OBJECT: {
                    LinkedTreeMap<String, Object> map = new LinkedTreeMap<String, Object>();
                    in.beginObject();
                    while (in.hasNext()) {
                        map.put(in.nextName(), this.read(in));
                    }
                    in.endObject();
                    return map;
                }
                case STRING: {
                    return in.nextString();
                }
                case NUMBER: {
                    String n = in.nextString();
                    if (n.indexOf(46) != -1) {
                        return Double.parseDouble(n);
                    }
                    long l = Long.parseLong(n);
                    if (l < Integer.MAX_VALUE) {
                        return (int)l;
                    }
                    return l;
                }
                case BOOLEAN: {
                    return in.nextBoolean();
                }
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            throw new IllegalStateException();
        }
    }
}

