/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance;

import com.kumuluz.ee.common.Extension;
import com.kumuluz.ee.common.config.EeConfig;
import com.kumuluz.ee.common.dependencies.EeComponentDependency;
import com.kumuluz.ee.common.dependencies.EeComponentType;
import com.kumuluz.ee.common.dependencies.EeExtensionDef;
import com.kumuluz.ee.common.wrapper.KumuluzServerWrapper;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.config.IsEnabledConfig;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EeExtensionDef(name="hystrix", group="fault.tolerance")
@EeComponentDependency(value=EeComponentType.CDI, implementations={"Weld"})
public class HystrixFaultToleranceExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(HystrixFaultToleranceExtension.class);

    public void init(KumuluzServerWrapper kumuluzServerWrapper, EeConfig eeConfig) {
        log.info("Initialising fault tolerance implemented by Hystrix.");
        IsEnabledConfig.setEnabled((boolean)true);
    }

    public void load() {
        log.info("Initialised fault tolerance implemented by Hystrix.");
    }

    public boolean isEnabled() {
        ConfigurationUtil configurationUtil = ConfigurationUtil.getInstance();
        Optional enabled = configurationUtil.getBoolean("kumuluzee.fault-tolerance.hystrix.enabled");
        if (enabled.isPresent()) {
            return (Boolean)enabled.get();
        }
        enabled = configurationUtil.getBoolean("kumuluzee.fault-tolerance.enabled");
        return enabled.orElse(true);
    }
}

