/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.commands;

import com.kumuluz.ee.fault.tolerance.exceptions.FaultToleranceConfigException;
import com.kumuluz.ee.fault.tolerance.models.DefaultFallbackExecutionContext;
import com.kumuluz.ee.fault.tolerance.models.ExecutionMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.jboss.weld.context.RequestContext;

public class FallbackHelper {
    private static final Logger log = Logger.getLogger(FallbackHelper.class.getName());

    public static Object executeFallback(Throwable cause, ExecutionMetadata metadata, InvocationContext ic, RequestContext rc) throws Exception {
        if (cause != null) {
            log.finest("Callback for command '" + metadata.getIdentifier() + "' fired by " + cause.getClass().getName());
        }
        boolean rcActivated = false;
        try {
            if (metadata.getFallbackHandlerClass() != null) {
                if (rc != null && !rc.isActive()) {
                    rc.activate();
                    rcActivated = true;
                }
                Instance fallbackCdi = CDI.current().select(metadata.getFallbackHandlerClass(), new Annotation[0]);
                FallbackHandler fallbackHandler = (FallbackHandler)fallbackCdi.get();
                DefaultFallbackExecutionContext executionContext = new DefaultFallbackExecutionContext();
                executionContext.setMethod(ic.getMethod());
                executionContext.setParameters(ic.getParameters());
                executionContext.setFailiure(cause);
                metadata.getFallbackMetricsCollection(ic.getMethod().getName()).ifPresent(c -> c.getTotalCalls().inc());
                Object response = fallbackHandler.handle((ExecutionContext)executionContext);
                CDI.current().destroy((Object)fallbackCdi);
                Object object = response;
                return object;
            }
            if (metadata.getFallbackMethod() != null) {
                metadata.getFallbackMetricsCollection(ic.getMethod().getName()).ifPresent(c -> c.getTotalCalls().inc());
                Object fallbackCdi = metadata.getFallbackMethod().invoke(ic.getTarget(), ic.getParameters());
                return fallbackCdi;
            }
            try {
                String msg = "Fallback should not be invoked if both fallback mechanisms (fallbackHandler and fallbackMethod) are undefined.";
                log.severe(msg);
                throw new FaultToleranceConfigException(msg);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String msg = "Exception occured while trying to invoke fallback method for key '" + metadata.getCommandKey() + "': " + e.getClass().getName();
                log.severe(msg);
                throw new FaultToleranceException(msg, (Throwable)e);
            }
        }
        finally {
            if (rcActivated && rc.isActive()) {
                rc.deactivate();
            }
        }
    }
}

