/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.commands;

import com.kumuluz.ee.fault.tolerance.enums.CircuitBreakerType;
import com.kumuluz.ee.fault.tolerance.metrics.CircuitBreakerMetricsCollection;
import com.kumuluz.ee.fault.tolerance.models.ExecutionMetadata;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SuccessThresholdCircuitBreaker
implements HystrixCircuitBreaker {
    private final HystrixCommandProperties properties;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.CLOSED);
    private final AtomicLong circuitOpened = new AtomicLong(-1L);
    private int successThreshold;
    private CircuitBreakerMetricsCollection metricsCollection;
    private AtomicLong remainingHalfOpenInvocations = new AtomicLong(this.successThreshold);
    private AtomicLong successfulInvocations = new AtomicLong(0L);
    private AtomicLong failedInvocations = new AtomicLong(0L);
    private Map<Status, AtomicLong> timeSpentInStatus;
    private Instant previousChangeTime;

    private SuccessThresholdCircuitBreaker(HystrixCommandProperties properties, Integer successThreshold, CircuitBreakerMetricsCollection metricsCollection) {
        this.properties = properties;
        this.successThreshold = successThreshold == null ? 1 : successThreshold;
        this.metricsCollection = metricsCollection;
        this.timeSpentInStatus = new HashMap<Status, AtomicLong>(Status.values().length);
        this.timeSpentInStatus.put(Status.CLOSED, new AtomicLong(0L));
        this.timeSpentInStatus.put(Status.OPEN, new AtomicLong(0L));
        this.timeSpentInStatus.put(Status.HALF_OPEN, new AtomicLong(0L));
        this.previousChangeTime = Instant.now();
        if (metricsCollection != null) {
            metricsCollection.registerClosedGauge(() -> this.getTimeSpentInStatus(Status.CLOSED));
            metricsCollection.registerOpenGauge(() -> this.getTimeSpentInStatus(Status.OPEN));
            metricsCollection.registerHalfOpenGauge(() -> this.getTimeSpentInStatus(Status.HALF_OPEN));
        }
    }

    public void markSuccess() {
        if (this.successfulInvocations.incrementAndGet() == (long)this.successThreshold && !this.status.get().equals((Object)Status.CLOSED)) {
            this.circuitOpened.set(-1L);
            Status previousStatus = this.status.getAndSet(Status.CLOSED);
            this.successfulInvocations.set(0L);
            this.failedInvocations.set(0L);
            this.remainingHalfOpenInvocations.set(this.successThreshold);
            this.markStatusChange(previousStatus);
        }
        this.checkThresholds();
    }

    public void markNonSuccess() {
        if (this.status.compareAndSet(Status.HALF_OPEN, Status.OPEN)) {
            this.circuitOpened.set(System.currentTimeMillis());
            this.successfulInvocations.set(0L);
            this.failedInvocations.set(0L);
            this.remainingHalfOpenInvocations.set(this.successThreshold);
            this.metricsCollection.getOpened().inc();
            this.markStatusChange(Status.HALF_OPEN);
        } else {
            this.failedInvocations.incrementAndGet();
            this.checkThresholds();
        }
    }

    public boolean isOpen() {
        if (((Boolean)this.properties.circuitBreakerForceOpen().get()).booleanValue()) {
            return true;
        }
        if (((Boolean)this.properties.circuitBreakerForceClosed().get()).booleanValue()) {
            return false;
        }
        return this.circuitOpened.get() >= 0L;
    }

    public boolean allowRequest() {
        throw new UnsupportedOperationException();
    }

    private boolean isAfterSleepWindow() {
        long sleepWindowTime;
        long circuitOpenTime = this.circuitOpened.get();
        long currentTime = System.currentTimeMillis();
        return currentTime > circuitOpenTime + (sleepWindowTime = (long)((Integer)this.properties.circuitBreakerSleepWindowInMilliseconds().get()).intValue());
    }

    private void checkThresholds() {
        long failed = this.failedInvocations.get();
        long sum = failed + this.successfulInvocations.get();
        if (sum >= (long)((Integer)this.properties.circuitBreakerRequestVolumeThreshold().get()).intValue() && (double)failed / (double)sum >= (double)((Integer)this.properties.circuitBreakerErrorThresholdPercentage().get()).intValue() / 100.0 && this.status.compareAndSet(Status.CLOSED, Status.OPEN)) {
            this.circuitOpened.set(System.currentTimeMillis());
            this.failedInvocations.set(0L);
            this.successfulInvocations.set(0L);
            this.remainingHalfOpenInvocations.set(this.successThreshold);
            if (this.metricsCollection != null) {
                this.metricsCollection.getOpened().inc();
                this.markStatusChange(Status.CLOSED);
            }
        }
    }

    public boolean attemptExecution() {
        if (((Boolean)this.properties.circuitBreakerForceOpen().get()).booleanValue()) {
            return false;
        }
        if (((Boolean)this.properties.circuitBreakerForceClosed().get()).booleanValue()) {
            return true;
        }
        if (this.circuitOpened.get() == -1L) {
            return true;
        }
        if (this.isAfterSleepWindow()) {
            return this.remainingHalfOpenInvocations.decrementAndGet() >= 0L;
        }
        return false;
    }

    private void markStatusChange(Status previous) {
        Instant changeTime = Instant.now();
        this.timeSpentInStatus.get((Object)previous).addAndGet(Duration.between(this.previousChangeTime, changeTime).toNanos());
        this.previousChangeTime = changeTime;
    }

    private Long getTimeSpentInStatus(Status status) {
        long time = this.timeSpentInStatus.get((Object)status).get();
        if (this.status.get().equals((Object)status)) {
            time += Duration.between(this.previousChangeTime, Instant.now()).toNanos();
        }
        return time;
    }

    public static class CustomCbFactory
    extends HystrixCircuitBreaker.Factory {
        private static ConcurrentHashMap<String, HystrixCircuitBreaker> circuitBreakersByCommand = new ConcurrentHashMap();

        public static HystrixCircuitBreaker getInstance(HystrixCommandKey key, HystrixCommandGroupKey group, HystrixCommandProperties properties, HystrixCommandMetrics metrics, ExecutionMetadata metadata, CircuitBreakerMetricsCollection metricsCollection) {
            String mapKey = key.name();
            HystrixCircuitBreaker previouslyCached = circuitBreakersByCommand.get(mapKey);
            if (previouslyCached != null) {
                return previouslyCached;
            }
            SuccessThresholdCircuitBreaker instance = metadata.getCircuitBreakerType().equals((Object)CircuitBreakerType.HYSTRIX) ? HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)key, (HystrixCommandGroupKey)group, (HystrixCommandProperties)properties, (HystrixCommandMetrics)metrics) : new SuccessThresholdCircuitBreaker(properties, metadata.getCircuitBreakerSuccessThreshold(), metricsCollection);
            HystrixCircuitBreaker cbForCommand = circuitBreakersByCommand.putIfAbsent(mapKey, instance);
            if (cbForCommand == null) {
                return circuitBreakersByCommand.get(mapKey);
            }
            return cbForCommand;
        }
    }

    static enum Status {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

