/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.configurations.hystrix;

import com.kumuluz.ee.fault.tolerance.configurations.hystrix.HystrixFaultToleranceConfigurationManager;
import com.kumuluz.ee.fault.tolerance.enums.HystrixConfigurationType;
import com.kumuluz.ee.fault.tolerance.models.ConfigurationProperty;
import com.kumuluz.ee.fault.tolerance.models.ExecutionMetadata;
import com.netflix.hystrix.HystrixCommandProperties;
import java.time.Duration;
import java.util.logging.Logger;

public abstract class AbstractHystrixConfigurationUtil {
    private static final Logger log = Logger.getLogger(AbstractHystrixConfigurationUtil.class.getName());
    protected HystrixFaultToleranceConfigurationManager configManager;

    public AbstractHystrixConfigurationUtil(HystrixFaultToleranceConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public abstract void initialize(ExecutionMetadata var1);

    public abstract void updateProperty(ConfigurationProperty var1, Object var2);

    protected abstract String toHystrixPropertyPath(ConfigurationProperty var1, boolean var2);

    protected abstract void initializeWatchedProperty(ConfigurationProperty var1, ConfigurationProperty var2, Object var3);

    public void setHystrixProperty(ConfigurationProperty property, HystrixConfigurationType type, String key, Object value) {
        this.setHystrixProperty(property, type, key, value, false);
    }

    public void setHystrixProperty(ConfigurationProperty property, HystrixConfigurationType type, String key, Object value, boolean changeable) {
        String hystrixProperyPath = this.toHystrixPropertyPath(property, changeable);
        Object hystrixValue = this.convertToHystrixValue(property, value);
        log.finest("Setting Hystrix propery '" + hystrixProperyPath + "' to value '" + hystrixValue + "'.");
        if (hystrixProperyPath != null) {
            this.configManager.setHystrixConfig(type, key, hystrixProperyPath, hystrixValue);
        }
    }

    public boolean isHystrixPropertyChangeable(ConfigurationProperty property) {
        return this.toHystrixPropertyPath(property, true) != null;
    }

    public Object convertToHystrixValue(ConfigurationProperty property, Object value) {
        switch (property.typeConfigurationPath()) {
            case "circuit-breaker.failure-ratio": {
                if (!(value instanceof Double)) break;
                return (int)((Double)value * 100.0);
            }
            case "bulkhead.metrics.rolling-window.size": 
            case "circuit-breaker.delay": 
            case "circuit-breaker.metrics.rolling-window.size": 
            case "circuit-breaker.metrics.health-interval": 
            case "timeout.value": {
                if (!(value instanceof Duration)) break;
                return ((Duration)value).toMillis();
            }
            case "bulkhead.keep-alive": {
                if (!(value instanceof Duration)) break;
                return ((Duration)value).toMinutes();
            }
            case "asynchronous.value": {
                if (!(value instanceof Boolean)) break;
                return (Boolean)value != false ? HystrixCommandProperties.ExecutionIsolationStrategy.THREAD : HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE;
            }
        }
        return value;
    }
}

