/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.configurations.hystrix;

import com.kumuluz.ee.fault.tolerance.configurations.hystrix.AbstractHystrixConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.configurations.hystrix.HystrixFaultToleranceConfigurationManager;
import com.kumuluz.ee.fault.tolerance.enums.FaultToleranceType;
import com.kumuluz.ee.fault.tolerance.enums.HystrixConfigurationType;
import com.kumuluz.ee.fault.tolerance.models.ConfigurationProperty;
import com.kumuluz.ee.fault.tolerance.models.ExecutionMetadata;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class CommandHystrixConfigurationUtil
extends AbstractHystrixConfigurationUtil {
    private static final Logger log = Logger.getLogger(CommandHystrixConfigurationUtil.class.getName());

    public CommandHystrixConfigurationUtil(HystrixFaultToleranceConfigurationManager configManager) {
        super(configManager);
    }

    @Override
    public void initialize(ExecutionMetadata metadata) {
        boolean isFallback;
        String commandKey = metadata.getCommandKey();
        String groupKey = metadata.getGroupKey();
        FaultToleranceType type = FaultToleranceType.ASYNCHRONOUS;
        if (!metadata.isAsynchronous()) {
            this.intializeProperty(commandKey, groupKey, type, "value", false);
        }
        CircuitBreaker cb = metadata.getCircuitBreaker();
        type = FaultToleranceType.CIRCUIT_BREAKER;
        if (cb != null) {
            log.info("Initializing circuit breaker pattern for command '" + metadata.getIdentifier() + "'.");
            this.intializeProperty(commandKey, groupKey, type, "request-volume-threshold", cb.requestVolumeThreshold());
            this.intializeProperty(commandKey, groupKey, type, "failure-ratio", cb.failureRatio());
            Duration delay = Duration.of(cb.delay(), cb.delayUnit());
            this.intializeProperty(commandKey, groupKey, type, "delay", delay);
            this.intializeProperty(commandKey, groupKey, type, "metrics.rolling-window.size", null);
            this.intializeProperty(commandKey, groupKey, type, "metrics.rolling-window.buckets", null);
            this.intializeProperty(commandKey, groupKey, type, "metrics.rolling-percentile.enabled", null);
            this.intializeProperty(commandKey, groupKey, type, "metrics.rolling-percentile.size", null);
            this.intializeProperty(commandKey, groupKey, type, "metrics.rolling-percentile.buckets", null);
            this.intializeProperty(commandKey, groupKey, type, "metrics.rolling-percentile.bucket-size", null);
            this.intializeProperty(commandKey, groupKey, type, "metrics.health-interval", null);
            if (metadata.isAsynchronous()) {
                this.intializeProperty(commandKey, groupKey, type, "interrupt.on-timeout", null);
                this.intializeProperty(commandKey, groupKey, type, "interrupt.on-cancel", null);
            }
        } else {
            this.intializeProperty(commandKey, groupKey, type, "enabled", false);
        }
        type = FaultToleranceType.FALLBACK;
        boolean bl = isFallback = metadata.getRetry() == null && (metadata.getFallbackHandlerClass() != null || metadata.getFallbackMethod() != null);
        if (!isFallback) {
            this.intializeProperty(commandKey, groupKey, type, "enabled", false);
        } else if (cb != null) {
            log.info("Initializing fallback pattern for command '" + commandKey + "'");
            this.intializeProperty(commandKey, groupKey, type, "max-requests", null);
        }
        Bulkhead bulkhead = metadata.getBulkhead();
        type = FaultToleranceType.BULKHEAD;
        if (bulkhead != null && !metadata.isAsynchronous()) {
            log.info("Initializing semaphored bulkhead pattern for command '" + commandKey + "'.");
            this.intializeProperty(commandKey, groupKey, type, "value", bulkhead.value());
        }
        Timeout timeout = metadata.getTimeout();
        type = FaultToleranceType.TIMEOUT;
        if (timeout != null) {
            log.info("Initializing timeout pattern for command '" + commandKey + "'.");
            Duration value = Duration.of(timeout.value(), timeout.unit());
            this.intializeProperty(commandKey, groupKey, type, "value", value);
            this.intializeProperty(commandKey, groupKey, type, "enabled", true);
        } else {
            this.intializeProperty(commandKey, groupKey, type, "enabled", false);
        }
    }

    @Override
    public void updateProperty(ConfigurationProperty property, Object value) {
        this.setHystrixProperty(property, HystrixConfigurationType.COMMAND, property.getCommandKey(), value, true);
    }

    @Override
    protected void initializeWatchedProperty(ConfigurationProperty property, ConfigurationProperty appliedProperty, Object defaultValue) {
        boolean isChangeable = this.isHystrixPropertyChangeable(property);
        this.setHystrixProperty(property, HystrixConfigurationType.COMMAND, property.getCommandKey(), appliedProperty.getValue(), isChangeable);
        if (isChangeable) {
            this.configManager.intializeWatch(HystrixConfigurationType.COMMAND, appliedProperty, property);
        }
    }

    @Override
    protected String toHystrixPropertyPath(ConfigurationProperty property, boolean changeable) {
        switch (property.typeConfigurationPath()) {
            case "asynchronous.value": {
                return "execution.isolation.strategy";
            }
            case "bulkhead.value": {
                return "execution.isolation.semaphore.maxConcurrentRequests";
            }
            case "circuit-breaker.enabled": {
                return changeable ? null : "circuitBreaker.enabled";
            }
            case "circuit-breaker.request-volume-threshold": {
                return "circuitBreaker.requestVolumeThreshold";
            }
            case "circuit-breaker.failure-ratio": {
                return "circuitBreaker.errorThresholdPercentage";
            }
            case "circuit-breaker.delay": {
                return "circuitBreaker.sleepWindowInMilliseconds";
            }
            case "circuit-breaker.metrics.rolling-window.size": {
                return changeable ? null : "metrics.rollingStats.timeInMilliseconds";
            }
            case "circuit-breaker.metrics.rolling-window.buckets": {
                return changeable ? null : "metrics.rollingStats.numBuckets";
            }
            case "circuit-breaker.metrics.rolling-percentile.enabled": {
                return changeable ? null : "metrics.rollingPercentile.enabled";
            }
            case "circuit-breaker.metrics.rolling-percentile.size": {
                return changeable ? null : "metrics.rollingPercentile.timeInMilliseconds";
            }
            case "circuit-breaker.metrics.rolling-percentile.buckets": {
                return changeable ? null : "metrics.rollingPercentile.numBuckets";
            }
            case "circuit-breaker.metrics.rolling-percentile.bucket-size": {
                return changeable ? null : "metrics.rollingPercentile.bucketSize";
            }
            case "circuit-breaker.metrics.health-interval": {
                return "metrics.healthSnapshot.intervalInMilliseconds";
            }
            case "circuit-breaker.interrupt.on-timeout": {
                return "execution.isolation.thread.interruptOnTimeout";
            }
            case "circuit-breaker.interrupt.on-cancel": {
                return "execution.isolation.thread.interruptOnCancel";
            }
            case "circuit-breaker.log.enabled": {
                return "requestLog.enabled";
            }
            case "timeout.enabled": {
                return changeable ? null : "execution.timeout.enabled";
            }
            case "timeout.value": {
                return "execution.isolation.thread.timeoutInMilliseconds";
            }
            case "fallback.enabled": {
                return changeable ? null : "fallback.enabled";
            }
            case "fallback.max-requests": {
                return "fallback.isolation.semaphore.maxConcurrentRequests";
            }
        }
        return null;
    }

    private void intializeProperty(String commandKey, String groupKey, FaultToleranceType type, String propertyPath, Object defaultValue) {
        Optional<Object> configValue;
        boolean watchEnabled = false;
        boolean configValueFound = false;
        ConfigurationProperty property = new ConfigurationProperty(commandKey, groupKey, type, propertyPath);
        Optional<ConfigurationProperty> appliedProperty = this.configManager.findKumuluzConfig(commandKey, groupKey, type, propertyPath);
        if (appliedProperty.isPresent() && (configValue = this.configManager.getKumuluzConfig(appliedProperty.get())).isPresent()) {
            appliedProperty.get().setValue(configValue.get());
            configValueFound = true;
            watchEnabled = this.configManager.isWatchEnabled(appliedProperty.get());
        }
        if (watchEnabled) {
            this.initializeWatchedProperty(property, appliedProperty.get(), defaultValue);
        } else if (defaultValue != null || configValueFound) {
            this.setHystrixProperty(property, HystrixConfigurationType.COMMAND, commandKey, configValueFound ? appliedProperty.get().getValue() : defaultValue);
        }
    }
}

