/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.configurations.hystrix;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.configurations.hystrix.AbstractHystrixConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.configurations.hystrix.CommandHystrixConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.configurations.hystrix.ThreadPoolHystrixConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.enums.FaultToleranceType;
import com.kumuluz.ee.fault.tolerance.enums.HystrixConfigurationType;
import com.kumuluz.ee.fault.tolerance.interfaces.FaultToleranceUtil;
import com.kumuluz.ee.fault.tolerance.models.ConfigurationProperty;
import com.kumuluz.ee.fault.tolerance.utils.FaultToleranceHelper;
import com.netflix.config.ConfigurationManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.configuration.AbstractConfiguration;

@ApplicationScoped
public class HystrixFaultToleranceConfigurationManager {
    private static final Logger log = Logger.getLogger(HystrixFaultToleranceConfigurationManager.class.getName());
    private ConfigurationUtil kumuluzConfig;
    private AbstractConfiguration hystrixConfig;
    private Map<String, List<ConfigurationProperty>> commandWatchToUpdateMap;
    private Map<String, List<ConfigurationProperty>> threadPoolWatchToUpdateMap;
    @Inject
    private FaultToleranceUtil faultToleranceUtil;

    @PostConstruct
    private void init() {
        this.kumuluzConfig = ConfigurationUtil.getInstance();
        this.hystrixConfig = ConfigurationManager.getConfigInstance();
        this.commandWatchToUpdateMap = new HashMap<String, List<ConfigurationProperty>>();
        this.threadPoolWatchToUpdateMap = new HashMap<String, List<ConfigurationProperty>>();
    }

    public void setHystrixConfig(HystrixConfigurationType type, String key, String propertyPath, Object value) {
        String keyPath = this.toHystrixConfigKeyPath(type, key, propertyPath);
        this.setHystrixConfig(keyPath, value);
    }

    public void setHystrixConfig(String key, Object value) {
        this.hystrixConfig.setProperty(key, value);
    }

    public Object getHystrixConfig(String key, Object value) {
        return this.hystrixConfig.getProperty(key);
    }

    public String toHystrixConfigKeyPath(HystrixConfigurationType type, String key, String propertyPath) {
        return String.format("hystrix.%s.%s.%s", type.getConfigKey(), key, propertyPath);
    }

    public Optional<Object> getKumuluzConfig(ConfigurationProperty property) {
        switch (property.typeConfigurationPath()) {
            case "bulkhead.metrics.rolling-window.size": 
            case "bulkhead.keep-alive": 
            case "circuit-breaker.delay": 
            case "circuit-breaker.metrics.rolling-window.size": 
            case "circuit-breaker.metrics.health-interval": 
            case "timeout.value": {
                Optional<Duration> durationVal = this.getKumuluzConfigDuration(property.configurationPath());
                return durationVal.map(Duration::toMillis);
            }
            case "circuit-breaker.failure-ratio": {
                Optional<Double> doubleVal = this.getKumuluzConfigDouble(property.configurationPath());
                return doubleVal.isPresent() ? Optional.of(doubleVal.get()) : Optional.empty();
            }
            case "bulkhead.value-change-enabled": 
            case "asynchronous.value": 
            case "circuit-breaker.enabled": 
            case "circuit-breaker.metrics.rolling-percentile.enabled": 
            case "circuit-breaker.interrupt.on-timeout": 
            case "circuit-breaker.interrupt.on-cancel": 
            case "circuit-breaker.log.enabled": 
            case "timeout.enabled": 
            case "fallback.enabled": {
                Optional<Boolean> boolVal = this.getKumuluzConfigBoolean(property.configurationPath());
                return boolVal.isPresent() ? Optional.of(boolVal.get()) : Optional.empty();
            }
        }
        Optional<Integer> intVal = this.getKumuluzConfigInteger(property.configurationPath());
        return intVal.isPresent() ? Optional.of(intVal.get()) : Optional.empty();
    }

    public Optional<String> getKumuluzConfigString(String keyPath) {
        return this.kumuluzConfig.get(keyPath);
    }

    public Optional<Integer> getKumuluzConfigInteger(String keyPath) {
        return this.kumuluzConfig.getInteger(keyPath);
    }

    public Optional<Double> getKumuluzConfigDouble(String keyPath) {
        return this.kumuluzConfig.getDouble(keyPath);
    }

    public Optional<Boolean> getKumuluzConfigBoolean(String keyPath) {
        return this.kumuluzConfig.getBoolean(keyPath);
    }

    public Optional<Duration> getKumuluzConfigDuration(String keyPath) {
        Optional<String> value = this.getKumuluzConfigString(keyPath);
        if (value.isPresent()) {
            Duration duration = FaultToleranceHelper.parseDuration((String)value.get());
            return Optional.of(duration);
        }
        return Optional.empty();
    }

    public void intializeWatch(HystrixConfigurationType type, ConfigurationProperty watchProperty, ConfigurationProperty destProperty) {
        Map<String, List<ConfigurationProperty>> map;
        String configPath = watchProperty.configurationPath();
        String newPropertyKeyPath = destProperty.configurationPath();
        Map<String, List<ConfigurationProperty>> map2 = map = type == HystrixConfigurationType.COMMAND ? this.commandWatchToUpdateMap : this.threadPoolWatchToUpdateMap;
        if (map.containsKey(configPath)) {
            List<ConfigurationProperty> properties = map.get(configPath);
            if (properties.stream().noneMatch(p -> p.configurationPath().equals(newPropertyKeyPath))) {
                log.finest("Adding key path '" + newPropertyKeyPath + "' to key '" + configPath + "' in map.");
                properties.add(destProperty);
            }
        } else {
            log.info("Initializing config watch for key path '" + configPath + "'.");
            ArrayList<ConfigurationProperty> properties = new ArrayList<ConfigurationProperty>();
            properties.add(destProperty);
            log.finest("Adding key path '" + newPropertyKeyPath + "' to key '" + configPath + "' in map.");
            map.put(configPath, properties);
            this.faultToleranceUtil.watch(watchProperty);
        }
    }

    public void updateProperty(ConfigurationProperty property) {
        AbstractHystrixConfigurationUtil hystrixConfigurationUtil;
        List<ConfigurationProperty> toUpdate;
        String configPath = property.configurationPath();
        log.info("Received update for key path '" + configPath + "'.");
        if (this.commandWatchToUpdateMap.containsKey(configPath)) {
            toUpdate = this.commandWatchToUpdateMap.get(configPath);
            hystrixConfigurationUtil = new CommandHystrixConfigurationUtil(this);
        } else if (this.threadPoolWatchToUpdateMap.containsKey(configPath)) {
            toUpdate = this.threadPoolWatchToUpdateMap.get(configPath);
            hystrixConfigurationUtil = new ThreadPoolHystrixConfigurationUtil(this);
        } else {
            return;
        }
        toUpdate.forEach(p -> {
            log.info("Updating configuration key '" + p.configurationPath() + "' with value '" + property.getValue() + "'.");
            hystrixConfigurationUtil.updateProperty((ConfigurationProperty)p, property.getValue());
        });
    }

    public boolean isWatchEnabled(ConfigurationProperty property) {
        return this.faultToleranceUtil.isWatchEnabled(property);
    }

    public Optional<ConfigurationProperty> findKumuluzConfig(String groupKey, FaultToleranceType type, String propertyPath) {
        return this.faultToleranceUtil.findConfig(groupKey, type, propertyPath);
    }

    public Optional<ConfigurationProperty> findKumuluzConfig(String commandKey, String groupKey, FaultToleranceType type, String propertyPath) {
        return this.faultToleranceUtil.findConfig(commandKey, groupKey, type, propertyPath);
    }
}

