/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.configurations.hystrix;

import com.kumuluz.ee.fault.tolerance.configurations.hystrix.AbstractHystrixConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.configurations.hystrix.HystrixFaultToleranceConfigurationManager;
import com.kumuluz.ee.fault.tolerance.enums.FaultToleranceType;
import com.kumuluz.ee.fault.tolerance.enums.HystrixConfigurationType;
import com.kumuluz.ee.fault.tolerance.exceptions.FaultToleranceConfigException;
import com.kumuluz.ee.fault.tolerance.models.ConfigurationProperty;
import com.kumuluz.ee.fault.tolerance.models.ExecutionMetadata;
import java.util.Optional;
import java.util.logging.Logger;

public class ThreadPoolHystrixConfigurationUtil
extends AbstractHystrixConfigurationUtil {
    private static final Logger log = Logger.getLogger(ThreadPoolHystrixConfigurationUtil.class.getName());

    public ThreadPoolHystrixConfigurationUtil(HystrixFaultToleranceConfigurationManager configManager) {
        super(configManager);
    }

    @Override
    public void initialize(ExecutionMetadata metadata) {
        String key = metadata.getGroupKey();
        log.info("Initializing thread bulkhead pattern for group '" + key + "'.");
        this.intializeProperty(key, FaultToleranceType.BULKHEAD, "value", metadata.getBulkhead().value());
        this.intializeProperty(key, FaultToleranceType.BULKHEAD, "waiting-task-queue", metadata.getBulkhead().waitingTaskQueue());
        this.intializeProperty(key, FaultToleranceType.BULKHEAD, "waiting-task-queue-rejection", metadata.getBulkhead().waitingTaskQueue());
        this.intializeProperty(key, FaultToleranceType.BULKHEAD, "metrics.rolling-window.size", null);
        this.intializeProperty(key, FaultToleranceType.BULKHEAD, "metrics.rolling-window.buckets", null);
        this.intializeProperty(key, FaultToleranceType.BULKHEAD, "keep-alive", null);
    }

    @Override
    public void updateProperty(ConfigurationProperty property, Object value) {
        this.setHystrixProperty(property, HystrixConfigurationType.THREAD_POOL, property.getGroupKey(), value, true);
    }

    @Override
    protected void initializeWatchedProperty(ConfigurationProperty property, ConfigurationProperty appliedProperty, Object defaultValue) {
        boolean isChangeable = this.isHystrixPropertyChangeable(property);
        switch (property.typeConfigurationPath()) {
            case "bulkhead.value": {
                if (!(defaultValue instanceof Integer) || !(appliedProperty.getValue() instanceof Integer)) {
                    throw new FaultToleranceConfigException("One of provided values for watched bulkhead is not of type Integer: " + defaultValue + ", " + appliedProperty.getValue());
                }
                Integer bulkheadStaticValue = (Integer)defaultValue;
                Integer bulkheadDynamicalue = (Integer)appliedProperty.getValue();
                if (bulkheadStaticValue > bulkheadDynamicalue) {
                    bulkheadDynamicalue = bulkheadStaticValue;
                }
                ConfigurationProperty allowDivergedSizesProperty = new ConfigurationProperty(property.getGroupKey(), FaultToleranceType.BULKHEAD, "value-change-enabled");
                this.setHystrixProperty(allowDivergedSizesProperty, HystrixConfigurationType.THREAD_POOL, property.getGroupKey(), true);
                this.setHystrixProperty(property, HystrixConfigurationType.THREAD_POOL, property.getGroupKey(), bulkheadStaticValue);
                this.setHystrixProperty(property, HystrixConfigurationType.THREAD_POOL, property.getGroupKey(), bulkheadDynamicalue, true);
                break;
            }
            case "bulkhead.waiting-task-queue": {
                if (!(defaultValue instanceof Integer) || !(appliedProperty.getValue() instanceof Integer)) {
                    throw new FaultToleranceConfigException("One of provided values for watched bulkhead waiting task queue is not of type Integer: " + defaultValue + ", " + appliedProperty.getValue());
                }
                Integer queueStaticValue = (Integer)defaultValue;
                Integer queueDynamicValue = (Integer)appliedProperty.getValue();
                if (queueStaticValue < queueDynamicValue) {
                    queueDynamicValue = queueStaticValue;
                }
                this.setHystrixProperty(property, HystrixConfigurationType.THREAD_POOL, property.getGroupKey(), queueStaticValue);
                this.setHystrixProperty(property, HystrixConfigurationType.THREAD_POOL, property.getGroupKey(), queueDynamicValue, true);
                break;
            }
            default: {
                this.setHystrixProperty(property, HystrixConfigurationType.THREAD_POOL, property.getGroupKey(), appliedProperty.getValue(), isChangeable);
            }
        }
        if (isChangeable) {
            this.configManager.intializeWatch(HystrixConfigurationType.THREAD_POOL, appliedProperty, property);
        }
    }

    @Override
    protected String toHystrixPropertyPath(ConfigurationProperty property, boolean changeable) {
        switch (property.typeConfigurationPath()) {
            case "bulkhead.value": {
                return changeable ? "maximumSize" : "coreSize";
            }
            case "bulkhead.waiting-task-queue": {
                return changeable ? "queueSizeRejectionThreshold" : "maxQueueSize";
            }
            case "bulkhead.waiting-task-queue-rejection": {
                return "queueSizeRejectionThreshold";
            }
            case "bulkhead.value-change-enabled": {
                return changeable ? null : "allowMaximumSizeToDivergeFromCoreSize";
            }
            case "bulkhead.metrics.rolling-window.size": {
                return changeable ? null : "metrics.rollingStats.timeInMilliseconds";
            }
            case "bulkhead.metrics.rolling-window.buckets": {
                return changeable ? null : "metrics.rollingStats.numBuckets";
            }
            case "bulkhead.keep-alive": {
                return "keepAliveTimeMinutes";
            }
        }
        return null;
    }

    private void intializeProperty(String groupKey, FaultToleranceType type, String propertyPath, Object defaultValue) {
        Optional<Object> configValue;
        boolean watchEnabled = false;
        boolean configValueFound = false;
        ConfigurationProperty property = new ConfigurationProperty(groupKey, type, propertyPath);
        Optional<ConfigurationProperty> appliedProperty = this.configManager.findKumuluzConfig(groupKey, type, propertyPath);
        if (appliedProperty.isPresent() && (configValue = this.configManager.getKumuluzConfig(appliedProperty.get())).isPresent()) {
            appliedProperty.get().setValue(configValue.get());
            configValueFound = true;
            watchEnabled = this.configManager.isWatchEnabled(appliedProperty.get());
        }
        if (watchEnabled) {
            this.initializeWatchedProperty(property, appliedProperty.get(), defaultValue);
        } else if (defaultValue != null || configValueFound) {
            this.setHystrixProperty(property, HystrixConfigurationType.THREAD_POOL, groupKey, configValueFound ? appliedProperty.get().getValue() : defaultValue);
        }
    }
}

