/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.fault.tolerance.configurations.retry;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.fault.tolerance.configurations.retry.RetryConfig;
import com.kumuluz.ee.fault.tolerance.enums.FaultToleranceType;
import com.kumuluz.ee.fault.tolerance.interfaces.FaultToleranceUtil;
import com.kumuluz.ee.fault.tolerance.models.ConfigurationProperty;
import com.kumuluz.ee.fault.tolerance.models.ExecutionMetadata;
import com.kumuluz.ee.fault.tolerance.utils.FaultToleranceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RetryConfigurationManager {
    private static final Logger log = Logger.getLogger(RetryConfigurationManager.class.getName());
    private ConfigurationUtil config;
    private Map<String, RetryConfig> retryConfigs;
    private Map<String, List<String>> retryWatches;
    @Inject
    private FaultToleranceUtil faultToleranceUtil;

    @PostConstruct
    private void init() {
        this.config = ConfigurationUtil.getInstance();
        this.retryConfigs = new HashMap<String, RetryConfig>();
        this.retryWatches = new HashMap<String, List<String>>();
    }

    public void initializeRetry(ExecutionMetadata metadata) {
        Optional delayProperty;
        if (metadata.getRetry() == null) {
            return;
        }
        RetryConfig retryConfig = new RetryConfig(metadata.getRetry().retryOn(), metadata.getRetry().abortOn());
        Optional maxRetriesProperty = this.faultToleranceUtil.findConfig(metadata.getCommandKey(), metadata.getGroupKey(), FaultToleranceType.RETRY, "max-retries");
        if (maxRetriesProperty.isPresent()) {
            retryConfig.setMaxRetries((Integer)this.config.getInteger(((ConfigurationProperty)maxRetriesProperty.get()).configurationPath()).get());
            if (this.faultToleranceUtil.isWatchEnabled((ConfigurationProperty)maxRetriesProperty.get())) {
                this.initializeWatch((ConfigurationProperty)maxRetriesProperty.get(), metadata.getCommandKey());
            }
        } else {
            retryConfig.setMaxRetries(metadata.getRetry().maxRetries());
        }
        if ((delayProperty = this.faultToleranceUtil.findConfig(metadata.getCommandKey(), metadata.getGroupKey(), FaultToleranceType.RETRY, "delay")).isPresent()) {
            Duration duration = FaultToleranceHelper.parseDuration((String)((String)this.config.get(((ConfigurationProperty)delayProperty.get()).configurationPath()).get()));
            retryConfig.setDelayInMillis(duration.toMillis());
            if (this.faultToleranceUtil.isWatchEnabled((ConfigurationProperty)delayProperty.get())) {
                this.initializeWatch((ConfigurationProperty)delayProperty.get(), metadata.getCommandKey());
            }
        } else {
            retryConfig.setDelayInMillis(Duration.of(metadata.getRetry().delay(), metadata.getRetry().delayUnit()).toMillis());
        }
        Optional jitterProperty = this.faultToleranceUtil.findConfig(metadata.getCommandKey(), metadata.getGroupKey(), FaultToleranceType.RETRY, "jitter");
        if (jitterProperty.isPresent()) {
            Duration duration = FaultToleranceHelper.parseDuration((String)((String)this.config.get(((ConfigurationProperty)jitterProperty.get()).configurationPath()).get()));
            retryConfig.setJitterInMillis(duration.toMillis());
            if (this.faultToleranceUtil.isWatchEnabled((ConfigurationProperty)jitterProperty.get())) {
                this.initializeWatch((ConfigurationProperty)jitterProperty.get(), metadata.getCommandKey());
            }
        } else {
            retryConfig.setJitterInMillis(Duration.of(metadata.getRetry().jitter(), metadata.getRetry().jitterDelayUnit()).toMillis());
        }
        this.retryConfigs.put(metadata.getIdentifier(), retryConfig);
    }

    public void setRetryConfig(ConfigurationProperty property, Object value) {
        if (property.getType() != FaultToleranceType.RETRY || !this.retryConfigs.containsKey(property.getIdentifier())) {
            return;
        }
        RetryConfig retryConfig = this.retryConfigs.get(property.getIdentifier());
        switch (property.getPropertyPath()) {
            case "max-retries": {
                if (!(value instanceof Integer)) break;
                retryConfig.setMaxRetries((Integer)value);
                break;
            }
            case "delay": {
                if (!(value instanceof Duration)) break;
                retryConfig.setDelayInMillis(((Duration)value).toMillis());
                break;
            }
            case "jitter": {
                if (!(value instanceof Duration)) break;
                retryConfig.setJitterInMillis(((Duration)value).toMillis());
                break;
            }
        }
    }

    public RetryConfig getRetryConfig(String key) {
        return this.retryConfigs.get(key);
    }

    public void initializeWatch(ConfigurationProperty property, String newWatchCommandKey) {
        String configPath = property.configurationPath();
        if (this.retryWatches.containsKey(configPath)) {
            List<String> commandKeys = this.retryWatches.get(configPath);
            if (commandKeys.stream().noneMatch(ck -> ck.equals(newWatchCommandKey))) {
                log.finest("Adding command key '" + newWatchCommandKey + "' to key '" + configPath + "' in map.");
                commandKeys.add(newWatchCommandKey);
            }
        } else {
            log.info("Initializing config watch for key path '" + configPath + "'.");
            ArrayList<String> commandKeys = new ArrayList<String>();
            commandKeys.add(newWatchCommandKey);
            log.finest("Adding key path '" + newWatchCommandKey + "' to key '" + configPath + "' in map.");
            this.retryWatches.put(configPath, commandKeys);
            this.faultToleranceUtil.watch(property);
        }
    }

    public void updateProperty(ConfigurationProperty property) {
        String configPath = property.configurationPath();
        log.info("Received update for key path '" + configPath + "'.");
        if (this.retryWatches.containsKey(configPath)) {
            this.retryWatches.get(configPath).forEach(ck -> {
                log.info("Updating configuration key '" + ck + "' with value '" + property.getValue() + "'.");
                ConfigurationProperty commandProperty = new ConfigurationProperty(ck, null, property.getType(), property.getPropertyPath());
                this.setRetryConfig(commandProperty, property.getValue());
            });
        }
    }
}

