/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.kumuluz.ee.fault.tolerance.commands.FallbackHelper;
import com.kumuluz.ee.fault.tolerance.commands.HystrixCommandConfiguration;
import com.kumuluz.ee.fault.tolerance.commands.SuccessThresholdCircuitBreaker;
import com.kumuluz.ee.fault.tolerance.metrics.BulkheadMetricsCollection;
import com.kumuluz.ee.fault.tolerance.models.ExecutionMetadata;
import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.jboss.weld.context.RequestContext;

public class KumuluzHystrixGenericCommand
extends HystrixCommand<Object> {
    private static final Logger log = Logger.getLogger(KumuluzHystrixGenericCommand.class.getName());
    private final InvocationContext invocationContext;
    private final RequestContext requestContext;
    private final ExecutionMetadata metadata;
    private final BulkheadMetricsCollection bulkheadMetricsCollection;
    private Instant waitingStartTime;
    private boolean threadExecution = false;

    public KumuluzHystrixGenericCommand(HystrixCommandConfiguration configuration, InvocationContext invocationContext, RequestContext requestContext, ExecutionMetadata metadata) {
        super(configuration.getGroupKey(), configuration.getCommandKey(), configuration.getThreadPoolKey(), SuccessThresholdCircuitBreaker.CustomCbFactory.getInstance(configuration.getCommandKey(), configuration.getGroupKey(), HystrixPropertiesFactory.getCommandProperties((HystrixCommandKey)configuration.getCommandKey(), null), HystrixCommandMetrics.getInstance((HystrixCommandKey)configuration.getCommandKey(), (HystrixCommandGroupKey)configuration.getGroupKey(), (HystrixThreadPoolKey)configuration.getThreadPoolKey(), (HystrixCommandProperties)HystrixPropertiesFactory.getCommandProperties((HystrixCommandKey)configuration.getCommandKey(), null)), metadata, metadata.getCbMetricsCollection(invocationContext.getMethod().getName()).orElse(null)), null, null, null, null, null, null, null, null);
        this.invocationContext = invocationContext;
        this.requestContext = requestContext;
        this.metadata = metadata;
        this.bulkheadMetricsCollection = metadata.getBulkheadMetricsCollection(invocationContext.getMethod().getName()).orElse(null);
    }

    protected Object run() throws Exception {
        Object result;
        log.finest("Executing command '" + this.metadata.getCommandKey() + "'.");
        AtomicLong currentlyExecuting = null;
        if (this.bulkheadMetricsCollection != null) {
            this.bulkheadMetricsCollection.getCallsAccepted().inc();
            currentlyExecuting = this.bulkheadMetricsCollection.getCurrentlyExecuting();
            currentlyExecuting.incrementAndGet();
            if (this.metadata.isAsynchronous()) {
                this.bulkheadMetricsCollection.getCurrentlyWaiting().decrementAndGet();
                this.bulkheadMetricsCollection.getWaitingDuration().update(Duration.between(this.waitingStartTime, Instant.now()).toNanos());
            }
        }
        Object property = ConfigurationManager.getConfigInstance().getProperty("hystrix.command." + this.metadata.getCommandKey() + ".execution.isolation.strategy");
        boolean requestContextActivated = false;
        this.threadExecution = property == null || property == HystrixCommandProperties.ExecutionIsolationStrategy.THREAD;
        Instant startTime = null;
        Instant endTime = null;
        try {
            if (this.threadExecution && !this.requestContext.isActive()) {
                this.requestContext.activate();
                requestContextActivated = true;
            }
            startTime = Instant.now();
            result = this.invocationContext.proceed();
            endTime = Instant.now();
        }
        catch (Throwable e) {
            if (this.isFallbackInvokeable(e) || e instanceof BulkheadException) {
                throw e;
            }
            throw new HystrixBadRequestException(e.getMessage(), e);
        }
        finally {
            if (requestContextActivated && this.requestContext.isActive()) {
                this.requestContext.deactivate();
            }
            if (currentlyExecuting != null) {
                currentlyExecuting.decrementAndGet();
            }
            if (this.bulkheadMetricsCollection != null && startTime != null && endTime != null) {
                this.bulkheadMetricsCollection.getExecutionDuration().update(Duration.between(startTime, endTime).toNanos());
            }
        }
        return result;
    }

    protected Object getFallback() {
        log.finest("Executing fallback for command '" + this.metadata.getCommandKey() + "'.");
        Exception executionException = this.getExceptionFromThrowable(this.getExecutionException());
        try {
            return FallbackHelper.executeFallback(executionException, this.metadata, this.invocationContext, this.threadExecution ? this.requestContext : null);
        }
        catch (Exception e) {
            if (e instanceof FaultToleranceException) {
                throw (FaultToleranceException)e;
            }
            throw new FaultToleranceException((Throwable)e);
        }
    }

    public Future<Object> queue() {
        if (this.metadata.isAsynchronous() && this.bulkheadMetricsCollection != null) {
            this.bulkheadMetricsCollection.getCurrentlyWaiting().incrementAndGet();
            this.waitingStartTime = Instant.now();
        }
        return super.queue();
    }

    private boolean isFallbackInvokeable(Throwable e) {
        Class[] failOn;
        if (this.metadata.getCircuitBreaker() == null) {
            return true;
        }
        for (Class fo : failOn = this.metadata.getCircuitBreaker().failOn()) {
            if (!fo.isInstance(e)) continue;
            return true;
        }
        return false;
    }
}

