/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthRegistry {
    private static HealthRegistry instance;
    private ConcurrentMap<String, HealthCheck> healthChecks = new ConcurrentHashMap<String, HealthCheck>();

    private HealthRegistry() {
    }

    public static HealthRegistry getInstance() {
        if (instance == null) {
            instance = new HealthRegistry();
        }
        return instance;
    }

    public void register(String healthCheckName, HealthCheck healthCheck) {
        this.healthChecks.put(healthCheckName, healthCheck);
    }

    public void unregister(String healthCheckName) {
        this.healthChecks.remove(healthCheckName);
    }

    public List<HealthCheckResponse> getResults() {
        return this.healthChecks.values().parallelStream().map(HealthCheck::call).collect(Collectors.toList());
    }
}

