/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import com.kumuluz.ee.health.HealthRegistry;
import com.kumuluz.ee.health.models.HealthResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(HealthServlet.class.getName());
    private ConfigurationUtil configurationUtil;
    private HealthRegistry healthCheckRegistry;
    private ObjectMapper mapper;

    public void init() throws ServletException {
        this.configurationUtil = ConfigurationUtil.getInstance();
        this.healthCheckRegistry = HealthRegistry.getInstance();
        this.mapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        try (ServletOutputStream output = null;){
            output = response.getOutputStream();
            response.setStatus(200);
            List<HealthCheckResponse> results = this.healthCheckRegistry.getResults();
            HealthResponse healthResponse = new HealthResponse();
            healthResponse.setChecks(results);
            healthResponse.setOutcome(HealthCheckResponse.State.UP);
            for (HealthCheckResponse result : results) {
                if (!HealthCheckResponse.State.DOWN.equals((Object)result.getState())) continue;
                response.setStatus(503);
                healthResponse.setOutcome(HealthCheckResponse.State.DOWN);
                break;
            }
            if (this.configurationUtil.getBoolean("kumuluzee.health.servlet.enabled").orElse(true).booleanValue() || this.configurationUtil.getBoolean("kumuluzee.debug").orElse(false).booleanValue()) {
                response.setContentType("application/json");
                this.getWriter(request).writeValue((OutputStream)output, (Object)healthResponse);
            }
        }
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrintOff = "false".equals(request.getParameter("pretty"));
        return prettyPrintOff ? this.mapper.writer() : this.mapper.writerWithDefaultPrettyPrinter();
    }
}

