/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class DiskSpaceHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(DiskSpaceHealthCheck.class.getName());
    private static final long DEFAULT_THRESHOLD = 100000000L;

    public HealthCheckResponse call() {
        long threshold = ConfigurationUtil.getInstance().getLong("kumuluzee.health.checks.disk-space-health-check.threshold").orElse(100000000L);
        try {
            if (Files.getFileStore(Paths.get("/", new String[0])).getUsableSpace() >= threshold) {
                return HealthCheckResponse.named((String)DiskSpaceHealthCheck.class.getSimpleName()).up().build();
            }
            LOG.severe("Disk space is getting low.");
            return HealthCheckResponse.named((String)DiskSpaceHealthCheck.class.getSimpleName()).down().build();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "An exception occurred when trying to read disk space.", exception);
            return HealthCheckResponse.named((String)DiskSpaceHealthCheck.class.getSimpleName()).down().build();
        }
    }
}

