/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class EtcdHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(EtcdHealthCheck.class.getName());
    private static final String HEALTHY = "{\"health\": \"true\"}";

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder healthCheckResponseBuilder = HealthCheckResponse.named((String)EtcdHealthCheck.class.getSimpleName()).up();
        Optional connectionUrls = ConfigurationUtil.getInstance().getListSize("kumuluzee.health.checks.etcd-health-check");
        if (connectionUrls.isPresent()) {
            for (int i = 0; i < (Integer)connectionUrls.get(); ++i) {
                String connectionUrl = ConfigurationUtil.getInstance().get("kumuluzee.health.checks.etcd-health-check[" + i + "].connection-url").orElse("");
                this.checkEtcdStatus(connectionUrl, healthCheckResponseBuilder);
            }
        } else {
            String connectionUrl = ConfigurationUtil.getInstance().get("kumuluzee.health.checks.etcd-health-check.connection-url").orElse("");
            this.checkEtcdStatus(connectionUrl, healthCheckResponseBuilder);
        }
        return healthCheckResponseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEtcdStatus(String connectionUrl, HealthCheckResponseBuilder healthCheckResponseBuilder) {
        WebTarget webTarget = ClientBuilder.newClient().target(connectionUrl);
        try (Response response = null;){
            String result;
            response = webTarget.request().get();
            if (response.getStatus() == 200 && (result = (String)response.readEntity(String.class)) != null && result.equals(HEALTHY)) {
                healthCheckResponseBuilder.withData(connectionUrl, HealthCheckResponse.State.UP.toString());
                return;
            }
        }
        healthCheckResponseBuilder.withData(connectionUrl, HealthCheckResponse.State.DOWN.toString());
        healthCheckResponseBuilder.down();
    }
}

