/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.health.checks;

import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class HttpHealthCheck
implements HealthCheck {
    private static final Logger LOG = Logger.getLogger(HttpHealthCheck.class.getName());

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder healthCheckResponseBuilder = HealthCheckResponse.named((String)HttpHealthCheck.class.getSimpleName()).up();
        Optional connectionUrls = ConfigurationUtil.getInstance().getListSize("kumuluzee.health.checks.http-health-check");
        if (connectionUrls.isPresent()) {
            for (int i = 0; i < (Integer)connectionUrls.get(); ++i) {
                String connectionUrl = ConfigurationUtil.getInstance().get("kumuluzee.health.checks.http-health-check[" + i + "].connection-url").orElse("");
                this.checkHttpStatus(connectionUrl, healthCheckResponseBuilder);
            }
        } else {
            String connectionUrl = ConfigurationUtil.getInstance().get("kumuluzee.health.checks.http-health-check.connection-url").orElse("");
            this.checkHttpStatus(connectionUrl, healthCheckResponseBuilder);
        }
        return healthCheckResponseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHttpStatus(String connectionUrl, HealthCheckResponseBuilder healthCheckResponseBuilder) {
        WebTarget webTarget = ClientBuilder.newClient().target(connectionUrl);
        try (Response response = null;){
            response = webTarget.request().head();
            if (response.getStatus() >= 200 && response.getStatus() < 300) {
                healthCheckResponseBuilder.withData(connectionUrl, HealthCheckResponse.State.UP.toString());
                return;
            }
        }
        healthCheckResponseBuilder.withData(connectionUrl, HealthCheckResponse.State.DOWN.toString());
        healthCheckResponseBuilder.down();
    }
}

